/* linker script para LPC2114  */
/* memoria Flash = 128Kb, Memoria SARM = 16kB */

MEMORY
{
    flash (rx) : org = 0x00000000, len = 0x00020000
    sram  (rw) : org = 0x20000000, len = 0x00004000
}
SECTIONS
{
    /* .text Sección de código ejecutable */

    .text :
    {
        *head.o (.text)
	*(.text)
    } > flash
    . = ALIGN(4);

    /* .rodata Seccion de variables de solo lectura */
    .rodata :
    {
        *(.rodata)
    } > flash
    . = ALIGN(4);

    /* .data Seccion de variables preinicializadas */
    /* Los valores de las variables preinicializadas son guardados
       en la flash para ser copiados por el head.s a la RAM cuando el 
       microcontrolador se inicializa */
    /* _data y _edata son punteros usados por head.s para determinar el rango de copia */

    _etext = . ;
    .data : AT (_etext)
    {
        _data = . ;
        *(.data)
     	_edata = . ;
     } > sram 
     . = ALIGN(4);
    /* .bss Seccion de variables no inicializadas */
    /* _bss y _ebss son punteros usados por head.s para determinar el rango de borrado o puesta a cero*/
    .bss :
    {
       	_bss = . ;
       	*(.bss)
 	_ebss = . ;
    } > sram
    . = ALIGN(4);
    _end = .;

    /* Stabs debugging sections.  */
    .stab          0 : { *(.stab) }
    .stabstr       0 : { *(.stabstr) }
    .stab.excl     0 : { *(.stab.excl) }
    .stab.exclstr  0 : { *(.stab.exclstr) }
    .stab.index    0 : { *(.stab.index) }
    .stab.indexstr 0 : { *(.stab.indexstr) }
    .comment       0 : { *(.comment) }
    /* DWARF debug sections.
       Symbols in the DWARF debugging sections are relative to the beginning
       of the section so we begin them at 0.  */
    /* DWARF 1 */
    .debug          0 : { *(.debug) }
    .line           0 : { *(.line) }
    /* GNU DWARF 1 extensions */
    .debug_srcinfo  0 : { *(.debug_srcinfo) }
    .debug_sfnames  0 : { *(.debug_sfnames) }
    /* DWARF 1.1 and DWARF 2 */
    .debug_aranges  0 : { *(.debug_aranges) }
    .debug_pubnames 0 : { *(.debug_pubnames) }
    /* DWARF 2 */
    .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }
    .debug_abbrev   0 : { *(.debug_abbrev) }
    .debug_line     0 : { *(.debug_line) }
    .debug_frame    0 : { *(.debug_frame) }
    .debug_str      0 : { *(.debug_str) }
    .debug_loc      0 : { *(.debug_loc) }
    .debug_macinfo  0 : { *(.debug_macinfo) }
    /* SGI/MIPS DWARF 2 extensions */
    .debug_weaknames 0 : { *(.debug_weaknames) }
    .debug_funcnames 0 : { *(.debug_funcnames) }
    .debug_typenames 0 : { *(.debug_typenames) }
    .debug_varnames  0 : { *(.debug_varnames) }
}
