#ifndef CPU
#error CPU shall be defined
#endif
#if (lpc4337 == CPU)
#include "chip.h"
#elif (mk60fx512vlq15 == CPU)
#else
#endif


#include "led.h"
void GPIO_Init() {
	Chip_GPIO_Init(LPC_GPIO_PORT);
}

void Led_Color_Init() {
	Chip_SCU_PinMux(2,0,MD_PUP,FUNC4); /* remapea P2_0 en GPIO5[0], LED0R y habilita el pull up*/
	Chip_SCU_PinMux(2,1,MD_PUP,FUNC4); /* remapea P2_1 en GPIO5[1], LED0G y habilita el pull up */
	Chip_SCU_PinMux(2,2,MD_PUP,FUNC4); /* remapea P2_2 en GPIO5[2], LED0B y habilita el pull up */

	Chip_SCU_PinMux(2,10,MD_PUP,FUNC0);
	Chip_SCU_PinMux(2,11,MD_PUP,FUNC0);
	Chip_SCU_PinMux(2,12,MD_PUP,FUNC0);

	Chip_GPIO_SetDir(LPC_GPIO_PORT,5,1<<0,1);
	Chip_GPIO_SetDir(LPC_GPIO_PORT,5,1<<1,1);
	Chip_GPIO_SetDir(LPC_GPIO_PORT,5,1<<2,1);

	Chip_GPIO_SetDir(LPC_GPIO_PORT,0,1<<14,1);
	Chip_GPIO_SetDir(LPC_GPIO_PORT,1,1<<11,1);
	Chip_GPIO_SetDir(LPC_GPIO_PORT,1,1<<12,1);
}
void Led_Port(int color,int *port,int *pin) {
	switch(color)
	{
		case LED_1:
			*port = 0;
			*pin  = 14;
			break;
		case LED_2:
			*port = 1;
			*pin = 11;
			break;
		case LED_3:
			*port = 1;
			*pin = 12;
			break;
		case LED_R:
			*port = 5;
			*pin = 0;
			break;
		case LED_G:
			*port = 5;
			*pin = 1;
			break;
		case LED_B:
			*port = 5;
			*pin = 2;
			break;

		default:
			*port = 1;
			*pin = 12;
			break;
	}
}
void Led_Color_Toggle(int color) {
	int port,pin;
	Led_Port(color,&port,&pin);
	Chip_GPIO_SetPinToggle(LPC_GPIO_PORT,port,pin);
}
void Led_Color_Hight(int color) {
	int port,pin;
	Led_Port(color,&port,&pin);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT,port,pin);
}
void Led_Color_Low(int color) {
	int port,pin;
	Led_Port(color,&port,&pin);
	Chip_GPIO_SetPinOutLow(LPC_GPIO_PORT,port,pin);
}

