/* Copyright 2014, ACSE & CADIEEL
 *    ACSE   : http://www.sase.com.ar/asociacion-civil-sistemas-embebidos/ciaa/
 *    CADIEEL: http://www.cadieel.org.ar
 *
 * This file is part of CIAA Firmware.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef _TEST_CIAADEVICES_
#define _TEST_CIAADEVICES_
/** \brief This file implements the test of the Devices
 **
 **/

/** \addtogroup CIAA_Firmware CIAA Firmware
 ** @{ */
/** \addtogroup POSIX POSIX Implementation
 ** @{ */
/** \addtogroup ModuleTests Module Tests
 ** @{ */

/*==================[inclusions]=============================================*/

/*==================[cplusplus]==============================================*/
#ifdef __cplusplus
extern "C" {
#endif

/*==================[macros]=================================================*/

/*==================[typedef]================================================*/

/*==================[external data declaration]==============================*/

/*==================[external functions declaration]=========================*/
/** \brief open test file */
int32_t testOpen0(uint8_t const * const path, uint8_t const oflag);

/** \brief close test function */
int32_t testClose0(int32_t fildes);

/** \brief ioctl test function */
int32_t testIoctl0(int32_t const fildes, int32_t request, void* param);

/** \brief read test function */
int32_t testRead0(int32_t const fildes, uint8_t * const buf, uint32_t nbyte);

/** \brief write test function */
int32_t testWrite0(int32_t const fildes, uint8_t const * const buf, uint32_t nbyte);

/** \brief seek test function */
int32_t testSeek0(int32_t const fildes, int32_t offset, uint8_t whence);

/** \brief open test file */
int32_t testOpen1(uint8_t const * const path, uint8_t const oflag);

/** \brief close test function */
int32_t testClose1(int32_t fildes);

/** \brief ioctl test function */
int32_t testIoctl1(int32_t const fildes, int32_t request, void* param);

/** \brief read test function */
int32_t testRead1(int32_t const fildes, uint8_t * const buf, uint32_t nbyte);

/** \brief write test function */
int32_t testWrite1(int32_t const fildes, uint8_t const * const buf, uint32_t nbyte);

/** \brief seek test function */
int32_t testSeek1(int32_t const fildes, int32_t offset, uint8_t whence);

/*==================[cplusplus]==============================================*/
#ifdef __cplusplus
}
#endif
/** @} doxygen end group definition */
/** @} doxygen end group definition */
/** @} doxygen end group definition */
/*==================[end of file]============================================*/
#endif /* #ifndef _TEST_CIAADEVICES_ */
