#include "gpio.h"

void gpio_init (enum PIN pin, enum DIRECTION dir)
{
  unsigned int pin_aux;                         //Variable auxiliar para el PORT1.
  if((pin >= PIN0_0) && (pin <= PIN0_30))       //Rango de pines del PORT0
  {
    if(pin <= PIN0_15)
    {
      PCB_PINSEL0 &= ~(3 << (2*pin));           //Configuro del pin P0.0 al P0.15 como GPIO.
    }
    else if(pin <= PIN0_30)
    {
      PCB_PINSEL1 &= ~(3 << (2*(pin-16)));      //Configuro del pin P0.16 al P0.30 como GPIO.
    }
    IODIR0 &= ~(1 << pin);                      //Mascara.
    IODIR0 |= (dir << pin);                     //Seteo de entrada o salida.
  }
  else if((pin >= PIN1_16) && (pin <= PIN1_31)) //Rango de pines del PORT1
  {
    if((pin >= PIN1_16) && (pin <= PIN1_25))
    {
      PCB_PINSEL2 &= ~(1 << 3);              //Configuro del pin P1.16 al P1.25 como GPIO.
    }
    else if((pin >= PIN1_26) && (pin <= PIN1_31))
    {
      PCB_PINSEL2 &= ~(1 << 2);                 //Configuro del pin P1.26 al P1.31 como GPIO.
    }
    pin_aux = pin - 15;                         //pin_aux posee el verdadero valor del PIN1.X
    IODIR1 &= ~(1 << pin_aux);                  //Mascara.
    IODIR1 |= (dir << pin_aux);                 //Seteo de entrada o salida.
  }
}

void gpio_set (enum PIN pin, enum STATE state)
{ 
  unsigned int pin_aux;           //Variable auxiliar para el PORT1.
  if((pin >= PIN0_0) && (pin <= PIN0_30) && (state != NONE))
  {
    if(state == ON)
    {
      IOSET0 = (1 << pin);
    }
    else
    {
      IOCLR0 = (1 << pin);
    }
  }
  if((pin >= PIN1_16) && (pin <= PIN1_31) && (state != NONE))
  { 
    pin_aux = pin - 15;           //pin_aux posee el verdadero valor del PIN1.X (Ej: 
    if(state == ON)               //pin=PIN1_16=31 decimal ==> pin_aux=16.
    {
      IOSET1 = (1 << pin_aux);
    }
    else
    {
      IOCLR1 = (1 << pin_aux);
    }
  }
}
void gpio_toggle (enum PIN pin)
{
  unsigned int pin_aux;
  if((pin >= PIN0_0) && (pin <= PIN0_30))
  {
    if( (IOPIN0 & (1 << pin)) == OFF)
    {
      IOSET0 = (1 << pin);
    }
    else
    {
      IOCLR0 = (1 << pin);
    }
  }
  if((pin >= PIN1_16) && (pin <= PIN1_31))
  {
    pin_aux= pin - 15;
    if( (IOPIN1 & (1 << pin_aux)) == OFF)
    {
      IOSET1 = (1 << pin_aux);
    }
    else
    {
      IOCLR1 = (1 << pin_aux);
    }
  }
}

unsigned int gpio_get_port (enum PORT port)
{
  if(port == PORT0)
  {
    return IOPIN0;
  }
  else if (port == PORT1)
  {
    return IOPIN1;
  }
  return 0;
}

enum STATE gpio_get_pin (enum PIN pin)
{
  unsigned int pin_aux;
  if((pin >= PIN0_0) && (pin <= PIN0_30))
  {
    return (1 & (IOPIN0 >> pin));
  }
  else if((pin >= PIN1_16) && (pin <= PIN1_31))
  {
    pin_aux= pin - 15;
    return (1 & (IOPIN1 >> pin_aux));
  }
  return NONE;
}
