#include "lpc2114.h"
/**Posible configuraci de los puerto, IN entrada y OUT salida.*/
enum DIRECTION {IN, OUT};   
/**Estados posibles de los puertos ante una lectura y/o escritura de los mismos.*/
enum STATE {OFF, ON, NONE};  
 /**Puertos de los que dispone este microcontrolador.*/
enum PORT {PORT0, PORT1};    
/**Pines de cada puerto del microcontrolador. Nomenclatura: "PINa_b", "a" es el puerto, 0 o 1, y "b" es el pin
 * propiamente dicho.*/
enum PIN {PIN0_0, PIN0_1, PIN0_2, PIN0_3, PIN0_4, PIN0_5, PIN0_6 , PIN0_7, PIN0_8, PIN0_9,
  PIN0_10, PIN0_11, PIN0_12, PIN0_13, PIN0_14, PIN0_15, PIN0_16, PIN0_17, PIN0_18, PIN0_19,
  PIN0_20, PIN0_21, PIN0_22, PIN0_23, PIN0_24, PIN0_25, PIN0_27=27, PIN0_28, PIN0_29,
  PIN0_30, PIN1_16=31, PIN1_17, PIN1_18, PIN1_19, PIN1_20, PIN1_21, PIN1_22, PIN1_23,
  PIN1_24, PIN1_25, PIN1_26, PIN1_27, PIN1_28, PIN1_29, PIN1_30, PIN1_31};

/**
 * \fn void gpio_init(enum PIN pin, enum DIRECTION dir).
 * \brief Esta funcin inicializa los puertos del microcontrolador.
 * \param 1) Un tipo de variable "enum PIN" que es el pin de dicho puerto que se quiere iniciar.
 * \param 2) la variable tipo "enum DIRECTION" configura a dicho pin como "IN" u "OUT".
 * \return No retorna ningn valor.
 * \author Nstor Levi Palomeque
 */
void gpio_init(enum PIN pin, enum DIRECTION dir);
/**
 * \fn void gpio_set(enum PIN pin, enum STATE state).
 * \brief Esta funcin setea un valor al pin correspondiente.
 * \param 1) Un tipo de variable "enum PIN" que es el pin de dicho puerto que se quiere setear.
 * \param 2) La variable tipo "enum STATE" es el valor que se setear al pin correspondiente. Con ON ( 1) el pin se
 * pone a 1, con OFF ( 0) el pin se pone a 0.
 * \return No retorna ningn valor.
 * \author Nstor Levi Palomeque
 */
void gpio_set(enum PIN pin, enum STATE state);
/**
 * \fn void gpio_toggle (enum PIN pin).
 * \brief Esta funcin realiza un toggle en el pin correspondiente.
 * \param 1) Un tipo de variable "enum PIN" que es el pin de dicho puerto al que se le aplicar el toggle.
 * \return No retorna ningn valor.
 * \author Nstor Levi Palomeque
 */
void gpio_toggle (enum PIN pin);
/**
 * \fn enum STATE gpio_get_pin(enum PIN pin).
 * \brief Esta funcin devuelve el estado del pin solicitado.
 * \param 1) Un tipo de variable "enum PIN" que es el pin de dicho puerto que se leer.
 * \return Retorna el estado del pin en un tipo de variable "enum STATE", si se desea leer un pin incorrecto devuelve
 * "NONE".
 * \author Nstor Levi Palomeque
 */
enum STATE gpio_get_pin(enum PIN pin);
/**
 * \fn unsigned int gpio_get_port(enum PORT port).
 * \brief Esta funcin devuelve el estado del puerto completo solicitado como parmetro.
 * \param 1) Un tipo de variable "enum PORT port" que es el puerto en cuestin.
 * \return Retorna, en un tipo de variable "unsigned int", el estado de todo el puerto.
 * \author Nstor Levi Palomeque
 */
unsigned int gpio_get_port(enum PORT port);


