#include "lpc2114.h"
#include "irq.h"

void irq_vect_init(enum IRQ_VIC source, unsigned char priority, unsigned long irq_function)
{
  if(priority <= 31)
  {
   
    (*(&(VICVectCntl0) + priority))  = source;        //Asinga la fuente de interrupcin.
    (*(&(VICVectCntl0) + priority)) |= 0x20;         //Habilita la fuente de interrupcin.
    (*(&(VICVectAddr0) + priority)) = irq_function;
     
/*  (*(REG32 (0xFFFFF200 + 4 * priority)))  = source;        //Asinga la fuente de interrupcin.
    (*(REG32 (0xFFFFF200 + 4 * priority))) |= 0x20;         //Habilita la fuente de interrupcin.
    (*(REG32 (0xFFFFF100 + 4 * priority))) = irq_function;
  */
  }
}
void irq_vect_enable(enum IRQ_VIC source)
{
  VICIntEnable |= (1 << source);
}

void irq_vect_disable(enum IRQ_VIC source)
{
  VICIntEnClear |= (1 << source);
}
