#include "lpc2114.h"

/**Fuentes de interrupciones del microcontrolador.*/
enum IRQ_VIC {VIC_WDT, VIC_ARM_Core_RX = 2, VIC_ARM_Core_TX, VIC_TIMER0, VIC_TIMER1, VIC_UART0, VIC_UART1, VIC_PWM0,
              VIC_I2C, VIC_SPI0, VIC_SPI1, VIC_PLL, VIC_RTC, VIC_EINT0, VIC_EINT1, VIC_EINT2, VIC_EINT3, VIC_AD}; 

/**
 * \fn void irq_vect_init(enum IRQ_VIC source, unsigned char priority, unsigned long irq_function).
 * \brief Esta funcin inicializa las 16 fuente de interrupcin pasada como parmetro.
 * \param 1) Un tipo de variable "enum IRQ_VIC source" que es la fuente de interrupcin que se desea inicializar.
 * \param 2) Un tipo de variable "unsigned char priority" que es la prioridad de dicha interrupcin en la VIC.
 * \param 3) Un tipo de variable "unsigned long irq_function" que es la direccin de la funcin que atiende la interrupcin.
 * \return No retorna ningn valor.
 * \warning Esta librera no atiende interrupciones FIQ e IRQ no vectorizadas.
 * \author Nstor Levi Palomeque
 */
void irq_vect_init(enum IRQ_VIC source, unsigned char priority, unsigned long irq_function);
/**
 * \fn void irq_vect_enable(enum IRQ_VIC source).
 * \brief Esta funcin habilita la fuente de interrupcin indicada como parmetro.
 * \param 1) Un tipo de variable "enum IRQ_VIC source" que es la fuente de interrupcin que se desea habilitar.
 * \return No retorna ningn valor.
 * \author Nstor Levi Palomeque
 */
void irq_vect_enable(enum IRQ_VIC source);
/**
 * \fn void irq_vect_disable(enum IRQ_VIC source).
 * \brief Esta funcin deshabilita la fuente de interrupcin indicada como parmetro.
 * \param 1) Un tipo de variable "enum IRQ_VIC source" que es la fuente de interrupcin que se desea deshabilitar.
 * \return No retorna ningn valor.
 * \author Nstor Levi Palomeque
 */
void irq_vect_disable(enum IRQ_VIC source);
