/**-----------------------------------------------------------------------
						Archivos de cabecera  					        
-------------------------------------------------------------------------*/  
#include "main.h"
#include "led.h"
#include "diskio.h"
#include "timer.h"
#include "irq.h"
#include "ff.h"
#include "uart.h"
#include "monitor.h"
#include "integer.h"
#include "adc.h"
#include "rtc.h"
#include "vumetro.h"
#include "memporc.h"
#include "math.h"
/**-----------------------------------------------------------------------
			Declaración de funciones e interrupciones.    					        
-------------------------------------------------------------------------*/  
void spi_init(void);
void LogFres(FRESULT ); 
void LogDres(DRESULT ); 
void LogClusterFree(FATFS *);
void Interrupcion_10ms(); 
void Interrupcion_5ms(); 
void imprimir_hora () __attribute__ ((interrupt,noinline));
void ExtraccionSegura(void);	 
void perisfericos_init(void);
void sd_init(void);
/**-----------------------------------------------------------------------
			  Declaración de variables globales.	     					        
-------------------------------------------------------------------------*/  
unsigned int	MostrarLectura = 1;
FRESULT fres;        //FatFs resultado de errores.
DRESULT dres;		 //Disk resultado de errores.
FATFS fs;        	 //Work area (file system object) for logical drives .
FATFS* ptr_fs;
FIL fdst,finfo;     		 //file objeto.
FIL* ptr_fdst;       //Puntero a archivo.
int rtc_resp = 0;	 //Variable para detectar la respuesta de la función settime y gettime.
char* ptr;
char Line[256];	
unsigned char c= 'E';
long p1,p2;
int i=0,err=0;
int lectura[4]={0},lectura_Acumulador[4]={0};
int mem_poc_ocup=0;
BOOL No_init_SD=FALSE,vum = TRUE;

RTC rtc_inicial = {	 //Creo variable de Hora inicial.
		0,0, 0,	// HH:MM:SS
		5, 18,  	// DíaSem, DíaMes, 
		11, 2010    // mes, anio
	};
/**-----------------------------------------------------------------------
						Comienzo del Main.	      					        
-------------------------------------------------------------------------*/  
int main (void)
{
	
  xfunc_in = UART_ByteReceive; //Lazo que une la librería Monitor con la Uart.
  xfunc_out = UART_ByteSend;   //Lazo que une la librería Monitor con la Uart.
  
  SCB_VPBDIV=0x1;//Oscilador a 60 Mhz. Con prescaler igual a 1.
  
  //Inicialización del timer de 10ms y del timer de 100ms.
  
  //Timer para interrumpir cada 10ms.
  timer_init(TIMER0, TIMER_MATCH0, INTERRUPT_ON_MATCH | RESET_ON_MATCH, 1, 0 , 0x8FFFC); 
  //Timer para interrumpir cada 5ms.	
  timer_init(TIMER1, TIMER_MATCH0, INTERRUPT_ON_MATCH | RESET_ON_MATCH, 1, 0 ,0x2DC6C0); 	//0x493E0
  callbacks_timer0_match0 = Interrupcion_10ms;  //Asignacion de los callbacks.
  callbacks_timer1_match0 = Interrupcion_5ms; //Asignacion de los callbacks.
  TIMER0_RESET();
  TIMER1_RESET();
  TIMER0_ENABLE();
  TIMER1_ENABLE();
  
  vumetro_init();		//Inicialización de los leds.  
  memporc_init();       //Inicialización de los leds para memporc = que vumetro_init().
  perisfericos_init();	//Inicialización de perisféricos.
  spi_init();			//Inicialización del módulo Spi.
  UART_Init();			//Inicializacion Uart.
  rtc_initialize ();	//Inicializa el Reloj de tiempo Real.	
  
  //Inicializa Interrupción RTC. Prioridad 0 -> (más importante).	
  irq_vect_init(VIC_RTC, 0, (unsigned long) imprimir_hora);	
  //Habilita Interrupción RTC.
  irq_vect_enable(VIC_RTC);
 
	rtc_resp = rtc_settime (&rtc_inicial);//Seteo de la hora inicial.
	sd_init();							  //Inicializa la memoria SD.	
	if (rtc_resp)
	{
		xputs("Hora Configurada \n");  //Si pudo setear la hora, muestra mensaje.
		rtc_resp = 0;
	}  	  
/**-----------------------------------------------------------------------
						Comienzo del ciclo infinito  		      					        
-------------------------------------------------------------------------*/  
   while(1)
   {
	   c=UART_ByteReceive();	
	   if(c=='c')
	   {
		   	xputs("\n****** Menu de Configuracion **********"); 
		   	xputs("\nq...anio Ej: a2010"); 		   
		   	xputs("\nw...mes(1-12)"); 	
		    xputs("\ne...dia(1-31)"); 	
		    xputs("\nr...hora(00-24)"); 	
		    xputs("\nt...minuto(00-60)"); 	
		    xputs("\ns...Extraer SD/MMC"); 			    
		    xputs("\ny...salir"); 		    
		    xputs("\n***************************************"); 
		    MostrarLectura = 0;//Detiene la muestra de datos en pantalla.
		    for(;;)
		    {
				c=UART_ByteReceive();
				switch(c)
				{
						case 'q':
										xputs("\n******* Cambiar Anio *******");	
										UART_ByteReceive();								
										get_line(Line, sizeof(Line));
										ptr = Line;
										if(xatoi(&ptr,&p1))
										{
											if((p1>4095)||(p1<1900))
											{
												xputs("Anio fuera de rango (1900-3000)");
											} 
											else
											{								    
												xprintf("Anio Ingresado : %ld ",p1);
												RTC_YEAR  = p1;
												break;					    
											}
										}
										else xputs("No se pudo obtener el Anio");
										break;
						case 'w':
										xputs("\n******* Cambiar Mes *******");	
										UART_ByteReceive();								
										get_line(Line, sizeof(Line));
										ptr = Line;
										if(xatoi(&ptr,&p1))
										{
											if((p1>12)||(p1<1))
											{
												xputs("Mes fuera de rango (1-12)");
											} 
											else
											{								    
												xprintf("Mes Ingresado : %ld ",p1);
												RTC_MONTH  = p1;
												break;					    
											}
										}
										else xputs("No se pudo obtener el Mes");
										break;	
						case 'e':
										xputs("\n******* Cambiar Dia *******");	
										UART_ByteReceive();								
										get_line(Line, sizeof(Line));
										ptr = Line;
										if(xatoi(&ptr,&p1))
										{
											if((p1>31)||(p1<1))
											{
												xputs("Dia fuera de rango (1-31)");
											} 
											else
											{								    
												xprintf("Dia Ingresado : %ld ",p1);
												RTC_DOM  = p1;
												break;					    
											}
										}
										else xputs("No se pudo obtener el Dia");
										break;																			
						case 'r':
										xputs("\n******* Cambiar Hora *******");	
										UART_ByteReceive();								
										get_line(Line, sizeof(Line));
										ptr = Line;
										if(xatoi(&ptr,&p1))
										{
											if((p1>24)||(p1<00))xputs("Hora fuera de rango");
											else
											{								    
												xprintf("Hora Ingresada : %ld ",p1);
												RTC_HOUR = p1;
												break;					    
											}
										}
										else xputs("No se pudo obtener la hora");
										break;	
						case 't':
										xputs("\n******* Cambiar Minutos *******");	
										UART_ByteReceive();								
										get_line(Line, sizeof(Line));
										ptr = Line;
										if(xatoi(&ptr,&p1))
										{
											if((p1>59)||(p1<00))xputs("Minutos fuera de rango");
											else
											{								    
												xprintf("Minutos Ingresados : %ld ",p1);
												RTC_MIN = p1;
												break;					    
											}
										}
										else xputs("No se pudo obtener los minutos");
										break;		
						case 's':
										xputs("\n******* Extrayendo SD/MMC *******");	
										ExtraccionSegura();
										break;																				
				}
				if(c == 'y')break;
			}
			for(i=0;i<=100000;i++);
			MostrarLectura =1;
		}
   }
   return 0;
}
/**-----------------------------------------------------------------------
						Interrupción que entra cada 10ms.  		      					        
-------------------------------------------------------------------------*/  
void Interrupcion_10ms()
{
		disk_timerproc();
}
/**-----------------------------------------------------------------------
						Interrupción que entra cada 5ms.		      					        
-------------------------------------------------------------------------*/  
void Interrupcion_5ms()
{
    static BOOL led_status = FALSE, pulsador_status = FALSE;
	static int flag1=0,flag2=1,aux=0;

		adc_init(1);//Inicializa el Adc en el canal 1.
		aux=(adc_read()*3000)/1024;
		if(aux >= 1500)
			aux = aux - 1500;
		else
			aux = 1500 - aux;	
		lectura_Acumulador[0]+= aux;//Acumula el valor leido.
		aux=0;
		
		adc_init(2);
		aux=(adc_read()*3000)/1024;
		if(aux >= 1500)
			aux = aux -1500;
		else
			aux = 1500 - aux;			
		lectura_Acumulador[1]+=aux;	
		aux=0;	
				
		adc_init(3);
		aux=(adc_read()*3000)/1024;
		if(aux >= 1500)
			aux = aux -1500;
		else
			aux = 1500 - aux;			
		lectura_Acumulador[2]+=aux;
		aux=0;
		
		adc_init(4);
		aux=(adc_read()*3000)/1024;
		if(aux >= 1500)
			aux = aux - 1500;
		else
			aux = 1500 - aux;			
		lectura_Acumulador[3]+=aux;
		aux=0;

	if(flag2 == 4)//Cada 100 muestras realiza el promedio.
	{
		lectura[0]=lectura_Acumulador[0]/4;  //Promedia los valores leidos. 
		lectura[1]=lectura_Acumulador[1]/4;
		lectura[2]=lectura_Acumulador[2]/4;
		lectura[3]=lectura_Acumulador[3]/4;		

		lectura_Acumulador[0]=0;	//Reinicio los acumulador.
		lectura_Acumulador[1]=0;	
		lectura_Acumulador[2]=0;	
		lectura_Acumulador[3]=0;	
				
		flag2=0;
	}	
	//Para ajustar la sensibilidad del vumetro cambiar el valor de flag1.
	if(flag1 == 2 && vum )//Muestra cada 100ms los valores en el vumetro.
	{
	
		vumetro(((lectura[0]*100)/1500),0); 
		vumetro(((lectura[1]*100)/1500),1); 
		vumetro(((lectura[2]*100)/1500),2); 
		vumetro(((lectura[3]*100)/1500),3); 		
		flag1=0;
	}
	flag1++;	//Incrementa las banderas.
	flag2++;
	
	//Chequeo de pulsadores y entradas
	
	//Chequear pulsador
	if(leer_pulsador)//Toma el valor entre 100ms y 200ms.
	{
		if(pulsador_status)
		{
			xputs("\n Leyendo pulsador\n");
			if(leer_insert && No_init_SD)
				sd_init();
			else
				ExtraccionSegura();
		    pulsador_status=FALSE;	
		}
		else	
			pulsador_status=TRUE;	
	}	
	//Chequear boton de insersión de memoria
	if(leer_insert)
	{
		led_rojo2_on;
	}
	else
	{
		led_rojo2_off;
		No_init_SD = TRUE;		
	}
	
	//Chequear estado de memoria	
	if(No_init_SD == TRUE)//Si la sd no esta inicializada o preparada cambia el led bicolor a rojo.
	{
		led_bicolor_rojo_on;
		led_bicolor_verde_off	
	}
	else
	{	
		led_bicolor_rojo_off;
		if(led_status == FALSE)
		{
			led_bicolor_verde_on; 
			led_status = TRUE;
		}
		else
		{
			led_bicolor_verde_off;
			led_status = FALSE;
		}
	}
	//Chequear llaves selectoras
	if(leer_switch_1)
	{
		vumetro_clr();
		vum = FALSE; //Apago el Vumetro.

	}
	else
	{
		vum = TRUE; //Prendo el Vumetro.
		if(flag1 > 2)flag1=0;//Reinicio la bandera

	}
	if(leer_switch_2)
	{
		vum = FALSE; //Apago el Vumetro.
	    memporc_clr();
		memporc(mem_poc_ocup); 
	}
	else
	{
	
	}

}
/**-----------------------------------------------------------------------
						Funcion Imprimir Hora. 		      					        
-------------------------------------------------------------------------*/  
void imprimir_hora ()
{	
	RTC rtc_actual;						 //Variable para obtener la fecha y hora. 
	rtc_resp = rtc_gettime (&rtc_actual);//Obtiene fecha y hora.
	static int cont=0;
	static BOOL led1_status =TRUE;
	int Db0=0,Db1=0,Db2=0,Db3=0;
   if(led1_status == TRUE)
   {
		led_rojo1_on;		
		led1_status = FALSE;
		
    }
    else
    {
		led_rojo1_off;
		led1_status = TRUE;		
	}  
    	cont++;
    	
    	 Db0= lectura[0]*2133.33334;
    	 Db0=20*log10f(Db0);    	
    	
    	 Db1= lectura[1]*2133.33334;
    	 Db1=20*log10f(Db1);    	
    	
    	 Db2= lectura[2]*2133.33334;
    	 Db2=20*log10f(Db2);

		 Db3= lectura[3]*2133.33334;
    	 Db3=20*log10f(Db3);

 	 
    	 
		if((cont >= 1)&&(No_init_SD == FALSE))
		{
					f_printf(&fdst, " \n%lu",cont-1);						
					f_printf(&fdst, " %02u/%02u/%02u ", rtc_actual.mday, rtc_actual.month, rtc_actual.year);					
					f_printf(&fdst, "%02u:%02u:%02u ", rtc_actual.hour, rtc_actual.min, rtc_actual.sec); 
					f_printf(&fdst,"%lu %lu %lu %lu dB", Db0,Db1,Db2,Db3); 
  	   }
    if(MostrarLectura){
		if (rtc_resp)		
		{
				xprintf("\n%lu",cont-1);
				xprintf(" %02u/%02u/%02u", rtc_actual.mday, rtc_actual.month, rtc_actual.year);		    
				xprintf(" %02u:%02u:%02u", rtc_actual.hour, rtc_actual.min, rtc_actual.sec);
				xprintf(" %lu %lu %lu %lu mV", lectura[0],lectura[1],lectura[2],lectura[3]);
				xprintf(" %lu %lu %lu %lu dB", Db0,Db1,Db2,Db3);
				rtc_resp = 0;
		}
		else
		{
			xprintf("%s", "\n No se pudo obtener la hora.");
		}
	}
	
/*Con este if iba aumentando en 5 segundos la alarma, para que salte la interrupción
 * a los 5, 10, 15, etc segundos. Si no se utiliza la alarma este if no sirve.
 * Se lo puede modificar para que salte la interrupción en otro momento
 */	
	if (RTC_ALSEC < 55)
		RTC_ALSEC = RTC_ALSEC + 1;
	else
		RTC_ALSEC = 0;

	RTC_ILR = 0x3; 			//Reseteo las interrupciones de la Alarma y la Interrupción.
	VICVectAddr = 0x00;		//Escritura que señala el fin de la interrupción.
	
}
/**-----------------------------------------------------------------------
			 Funcion Inicializar perisfericos Entradas y leds. 		      					        
-------------------------------------------------------------------------*/  
void perisfericos_init()
{
	
	PCB_PINSEL0 &= 0x3C0CFF3F; //Configuro los Pines P0.8 P0.10 P0.11 P0.12 P0.3. No se usa el P0.8 ,el P0.12 y el P0.15(insert).
	PCB_PINSEL2 &= 0xFFFFFFF3;	//Configuro Pines P1.16 - P1-31 como GPIO. 
	
	IODIR0 &= 0XFFFF73F7;	//Configuro P0.3, P0.10, P0.11 P0.15 como ENTRADA. P0.8 y P0.12 no los toco.
	IODIR1 |= 0x0F000000;	//Configuro P1.24, P1.25,  P1.26 y P1.27 como SALIDA.
	
	IOCLR1 |= 0x0F000000;	//Pone las salidas a masa.
	
}
/**-----------------------------------------------------------------------
						Inicializacion Spi. 		      					        
-------------------------------------------------------------------------*/  
void spi_init()
{
	PCB_PINSEL0 |= 0x5500;			//Configura los pines para ser usados como spi.
	SPI0_SPCCR=0x64;				//Configura el Clock Counter Register.
	SPI0_SPCR=0x20;					//Configura el Control Register.
}
/**-----------------------------------------------------------------------
				Funcion Inicializar la memoria y los archivos.	 		      					        
-------------------------------------------------------------------------*/  
void sd_init (void)
{
 
	  xputs("Inicializando SD");
	  dres = disk_initialize (0);//Inicialización de la Memoria por Spi.
	  LogDres(dres);
	  
	  if(dres == 0)//Si se pudo inicializar la Sd entonces muestra el espacio libre y el total.
	  {
		No_init_SD = FALSE;
		fres = f_mount(0, &fs);//Creo el area de trabajo.
		
		//Muestra información sobre el espacio disponible.			
		LogFres(fres);
		ptr_fs = &fs;
		LogClusterFree(ptr_fs);
		
		//Crea el sistema de carpetas.		
		fres = f_mkdir("0:/Db");
		LogFres(fres);			
		fres = f_mkdir("0:/Db/Info");
		LogFres(fres);		
		fres = f_mkdir("0:/Db/muestras");
		LogFres(fres);	

		
		//Voy a la carpeta de info.					
		f_chdir("0:/Db/info");
		//Crea el archivo destino de Info en el drive 0.		
		fres = f_open(&finfo, "0:/Db/info/info.txt", FA_CREATE_ALWAYS | FA_WRITE);
		LogFres(fres); 
		f_puts ("\n*************************************************************\n", &finfo);
		f_puts ("~~~~~~~~~~~~~~~ Universidad Tecnológica Nacional ~~~~~~~~~~~~\n", &finfo);
		f_puts ("~~~~~~~~~~~~~~~~~ Facultad Regional Córdoba ~~~~~~~~~~~~~~~~~\n", &finfo);
		f_puts ("************************************************************\n\n\n", &finfo);
		f_puts ("Proyecto:\n", &finfo);
		f_puts ("         Decibelimetro Digital Datalogger\n\n\n", &finfo);
		f_puts ("Materias:\n", &finfo);
		f_puts ("            Medidas Electrónicas 1\n", &finfo);		
		f_puts ("            Técnicas Digitales 2\n", &finfo);	
		f_puts ("            Electrónica Aplicada 2\n\n\n", &finfo);	
		f_puts ("Integrantes:\n", &finfo);
		f_puts ("            AGRESTA, Bruno Leg.52918\n", &finfo);		
		f_puts ("            DUJE, Nicolás Leg.52895\n", &finfo);	
		f_puts ("            MOYANO, Gabriel Leg.52693\n", &finfo);	
		f_puts ("            MUGNAINI, Guillermo Leg.53571\n", &finfo);			
		fres=f_close(&finfo);
	
				
		//Voy a la carpeta de Muestras.	
		xputs("Cambiando directorio a muestras");
		fres = f_chdir("0:/Db");	
		LogFres(fres);  			
		fres = f_chdir("0:/Db/muestras");
		LogFres(fres);  		
		//Crea el archivo destino de muestras en el drive 0.
		fres = f_open(&fdst, "0:/Db/muestras/muestras.txt", FA_OPEN_ALWAYS | FA_WRITE);
		LogFres(fres); 
		ptr_fdst = &fdst; 
		fres = f_lseek(ptr_fdst, ptr_fdst->fsize);//Lleva el puntero al final del archivo.
		f_puts ("\n********************************************************\n", &fdst);
		f_puts ("~~~~~~~~~~~~~~~~~~~~~~~ Muestras ~~~~~~~~~~~~~~~~~~~~~~~~~\n", &fdst);
		f_puts ("**********************************************************\n", &fdst);
		LogFres(fres);     
	   }
	   else
	   {
			  xputs("\n No se inicializo la SD"); 
			  No_init_SD =TRUE;
	   }
}
/**-----------------------------------------------------------------------
						Extraer SD/MMC.  		      					        
-------------------------------------------------------------------------*/  
void ExtraccionSegura()
{
						xputs("\n Cierro el archivo"); 
						fres=f_close(&fdst);
						LogFres(fres); 
						xputs("\n Desmonto la SD"); 
						fres=f_mount(0, 0);
						LogFres(fres);
						No_init_SD =TRUE;
						xputs("\n Estraccion segura de SD"); 						
}
/**-----------------------------------------------------------------------
		Función para Mostrar el los clusters libres en la memoria.  		      					        
-------------------------------------------------------------------------*/  
void LogClusterFree(FATFS  *fs)
{
    DWORD fre_clust, fre_sect,tot_sect;

    xputs("\n Info de espacio \n");
    //Obtengo información del volumen y de los clusters.
    fres = f_getfree("0:", &fre_clust, &fs);
    LogFres(fres);

    // Obtengo la cantidad de sectores y los libres.
    tot_sect = (fs->n_fatent - 2) * fs->csize;
    fre_sect = fre_clust * fs->csize;
	
	mem_poc_ocup=(int)((((tot_sect / 2)-(fre_sect / 2))*100)/(tot_sect / 2));
    // Imprime el la pantalla el espacio libre y el espacio total de la memoria.
    xputs("\n");
    xprintf("%lu"," Kb Libre.\n",(fre_sect / 2));
    xputs("Kb Libre.\n");
    xprintf("%lu",(tot_sect / 2));
    xputs("Kb Espacio Total\n");
    xprintf("%lu",mem_poc_ocup);
    xputs(" Porcentaje Ocupado \n");    
}
/**-----------------------------------------------------------------------
			Funcion para Mostrar el resultado de Fres por la Uart.  		      					        
-------------------------------------------------------------------------*/  
void LogFres(FRESULT fres)
{
	switch (fres)
	{
		case FR_OK:
					xputs("\n FR_OK ");
					break;
		case FR_DISK_ERR:
					xputs("\n FR_DISK_ERR ");
					break;
		case FR_INT_ERR:
					xputs("\n FR_INT_ERR ");
					break;
		case FR_NOT_READY:
					xputs("\n FR_NOT_READY ");
					break;
		case FR_NO_FILE:
					xputs("\n FR_NO_FILE ");
					break;
		case FR_NO_PATH:
					xputs("\n FR_NO_PATH" );
					break;
		case FR_INVALID_NAME:
					xputs("\n FR_INVALID_NAME ");
					break;					
		case FR_DENIED:
					xputs("\n FR_DENIED ");
					break;
		case FR_EXIST:
					xputs("\n FR_EXIST ");
					break;
		case FR_INVALID_OBJECT:
					xputs("\n FR_INVALID_OBJECT ");
					break;
		case FR_WRITE_PROTECTED:
					xputs("\n FR_WRITE_PROTECTED ");
					break;															
		case FR_INVALID_DRIVE:
					xputs("\n FR_INVALID_DRIVE ");
					break;																																			
		case FR_NOT_ENABLED:
					xputs("\n FR_NOT_ENABLED ");
					break;					
		case FR_NO_FILESYSTEM:
					xputs("\n FR_NO_FILESYSTEM ");
					break;						
		case FR_MKFS_ABORTED:
					xputs("\n FR_MKFS_ABORTED ");
					break;	
		case FR_TIMEOUT:
					xputs("\n FR_TIMEOUT ");
					break;
		case FR_LOCKED:
					xputs("\n FR_LOCKED ");
					break;		
		case FR_NOT_ENOUGH_CORE:
					xputs("\n FR_NOT_ENOUGH_CORE ");
					break;	
		case FR_TOO_MANY_OPEN_FILES:
					xputs("\n FR_TOO_MANY_OPEN_FILES ");
					break;					
	}
}
/**-----------------------------------------------------------------------
		Funcion para Mostrar el resultado de Dres por la Uart.   		      					        
-------------------------------------------------------------------------*/ 
void LogDres(DRESULT dres)
{
	switch (dres)
	{
		case RES_OK:
					xputs("\n RES_OK");
					break;
		case RES_ERROR:
					xputs("\n RES_ERROR");
					break;
		case RES_WRPRT:
					xputs("\n RES_WRPRT");
					break;
		case RES_NOTRDY:
					xputs("\n RES_NOTRDY");
					break;
		case RES_PARERR:
					xputs("\n RES_PARERR");
					break;				
	}
}
