#include "memporc.h"


void memporc_init() 
{


	PCB_PINSEL0 &= 0XF3F3FFFF; //Configuro los Pines P0.9 P0.13 
	PCB_PINSEL1 &= 0XFFF00000; //Configuro los Pines P0.16 - P0.25 como GPIO.
	PCB_PINSEL2 &= 0xFFFFFFF3;	//Configuro Pines P1.16 - P1-31 como GPIO. 
	
	IODIR0 |= 0X03FF2200;	//Configuro P0.9, P0.13, P0.16 - P0.25 como salida.
	IODIR1 |= 0x00FF0000;	//Configuro P1-16 - P1.23.
	
	IOCLR1 |= 0x00FF0000;	//Pone las salidas a masa.
	IOCLR0 |= 0X03FF2200;	//Pone las salidas a masa.
		
	
}

void memporc(int val) 
{	
	if(val > 5)  IOSET1 |= 0x00800000; //N1 D20 P1.23
	if(val > 10) IOSET1 |= 0x00040000; //N2 D15 P1.18
	if(val > 15) IOSET0 |= 0x00200000; //N3 D10 P0.21
	if(val > 20) IOSET0 |= 0x00010000; //N4 D05 P0.16
	
	if(val > 25) IOSET1 |= 0x00400000; //N5 D19 P1.22 
	if(val > 30) IOSET1 |= 0x00020000; //N6 D14 P1.17
	if(val > 35) IOSET0 |= 0x00100000; //N7 D09 P0.20
	if(val > 40) IOSET0 |= 0x00002000; //N8 D04 P0.13
	
	if(val > 45) IOSET1 |= 0x00200000; //N9 D18 P1.21
	if(val > 50) IOSET1 |= 0x00010000; //N10 D13 P1.16
	if(val > 55) IOSET0 |= 0x00080000; //N11 D08 P0.19
	if(val > 60) IOSET0 |= 0x00000200; //N12 D03 P0.9
	
	if(val > 65) IOSET1 |= 0x00100000; //N13 D17 P1.20
	if(val > 70) IOSET0 |= 0x00800000; //N14 D12 P0.23
	if(val > 75) IOSET0 |= 0x00040000; //N15 D07 P0.18	
	if(val > 80) IOSET0 |= 0x02000000; //N16 D02 P0.25
	
	if(val > 85) IOSET1 |= 0x00080000; //N17 D16 P1.19
	if(val > 90) IOSET0 |= 0x00400000; //N18 D11 P0.22
	if(val > 95) IOSET0 |= 0x00020000; //N19 D06 P0.17
	if(val <= 100 && val > 95) IOSET0 |= 0x01000000; //N20 D01 	P0.24											
	
}

void memporc_set(){
	IOSET1 |= 0x00FF0000;	//Pone las salidas a masa.
	IOSET0 |= 0X03FF2200;	//Pone las salidas a masa.
}

void memporc_clr(){
	IOCLR1 |= 0x00FF0000;	//Pone las salidas a masa.
	IOCLR0 |= 0X03FF2200;	//Pone las salidas a masa.
}
