/*--------------------------------------------------------------------------*/
/*  RTC controls                                                            */

#include "lpc2114.h"
#include "rtc.h"


int rtc_initialize (void)
{

	// Supply PCLK to the RTC */
	SCB_PCONP |= 0x00000200;		//Es como conectar el PCLK al RTC. Le mando el clock de periferico
		
	RTC_CCR = 0x1;					//Comienza el conteo del contador del RTC
	RTC_PREINT = 1799;				//PREINT = int (pclk / 32768) - 1 
									//PREINT = int (58982400 / 32768) - 1 = 1799
	RTC_PREFRAC = 0;
		
	
//------------AGREGADOS DE ALARMA E INTERRUPCIONES-----------------------	
	RTC_ILR=0x3;		//Clear the Interrupt Location Register

/*Este registro configura cuando se quiere que interrumpa el RTC. Puede ser por cada incremento de 
 * segundo, por cada incremento de minuto, de año, etc.
 * Ver la pagina 202, Tabla 146 de la hoja de datos del  mirco
 * 
 * Registro de 8 bits: IMYEAR, IMMON, IMDOY, IMDOW, IMDOM, IMHOUR, IMMIN, IMSEC
 * interru al minuto:	0		0		0		0	  0		0		1		0
 */  
	RTC_CIIR = 0x1;    	//Seteo que interrumpa a cada seg 00000001

/*Este registro configura cuando se quiere que salte la alarma del RTC. Puede ser a un cierto 
 * segundo, minuto, año, etc.
 * Ver la pagina 203, Tabla 147 de la hoja de datos del  mirco
 * 
 * Registro de 8 bits: AMRYEAR, AMRMON, AMRDOY, AMRDOW, AMRDOM, AMRHOUR, AMRMIN, AMRSEC
 * Alarm segundos:			1		1		1		1	  1			1		1		0
 */ 				
	RTC_AMR = 0xFF;  //Deshabilito las alarmas
	//RTC_ALSEC = 5;   //Seteo que la alarma sea a los 5 segundos
	
//------------FIN AGREGADOS DE ALARMA E INTERRUPCIONES-------------------

	
	/* Stop PCLK to the RTC to reduce power consumption */
	//SCB_PCONP &= 0xFFFFFDFF;
	return 1;
}

int rtc_gettime (RTC *rtc)
{
	DWORD d, t;

	do {
		t = RTC_CTIME0;
		d = RTC_CTIME1;
		
		
	} while (t != RTC_CTIME0 || d != RTC_CTIME1);

	rtc->sec = t & 63;				
	rtc->min = (t >> 8) & 63;		
	rtc->hour = (t >> 16) & 31;		
	rtc->wday = (t >> 24) & 7;
	rtc->mday = d & 31;
	rtc->month = (d >> 8) & 15;
	rtc->year = (d >> 16) & 4095;

	return 1;
}




int rtc_settime (const RTC *rtc)
{
	/* Supply PCLK to the RTC */
	SCB_PCONP |= 0x00000200;

	/* Stop RTC */
	RTC_CCR = 0x2;			//resetea el clock


	/* Update RTC registers */
	RTC_SEC = rtc->sec;
	RTC_MIN = rtc->min;
	RTC_HOUR = rtc->hour;
	RTC_DOW = rtc->wday;
	RTC_DOM = rtc->mday;
	RTC_MONTH = rtc->month;
	RTC_YEAR = rtc->year;

	/* Restart RTC with external XTAL */
	RTC_CCR = 0x1;
	
	/* Stop PCLK to the RTC to reduce power consumption */
	//SCB_PCONP &= 0xFFFFFDFF;

	return 1;
}


