#define TIMER_C

#include "timer.h"
#include "irq.h"
//#include "gpio.h"
#include "lpc2114.h"

//------------------------------------------------CAPTURE-----------------------------------------------------------------------------
void capture_init(unsigned char cap_pin, unsigned char mode, unsigned char priority)
{
  callbacks_timer0_capture0 = timer_callbacks_error;
  callbacks_timer0_capture1 = timer_callbacks_error;
  callbacks_timer0_capture2 = timer_callbacks_error;
  callbacks_timer0_capture3 = timer_callbacks_error;
  callbacks_timer1_capture0 = timer_callbacks_error;
  callbacks_timer1_capture2 = timer_callbacks_error;
  callbacks_timer1_capture3 = timer_callbacks_error;

  switch (cap_pin)
  {
   //////////////////////////////////  CAP0.0(TIMER0)   ////////////////////////////////
   case CAP00_P02:                   
        PCB_PINSEL0 &= 0xFFFFFFCF;  		//Pin P0.2 como CAP0.0(Timer0)
        PCB_PINSEL0 |= 0x00000020;	
        T0CCR &= 0xFF8;
        T0CCR |= (mode << 0);
        break;
   case CAP00_P022:
        PCB_PINSEL1 &= 0xFFFFCFFF;  		//Pin P0.22 como CAP0.0(Timer0)
        PCB_PINSEL1 |= 0x00002000; 
        T0CCR &= 0xFF8;                //Pone en cero los bits 0,1,2
        T0CCR |= (mode << 0);
        break;
   case CAP00_P030:
        PCB_PINSEL1 &= 0xCFFFFFFF;  		//Pin P0.30 como CAP0.0(Timer0)
        PCB_PINSEL1 |= 0x30000000;	
        T0CCR &= 0xFF8;                  //Pone en cero los bits 0,1,2
        T0CCR |= (mode << 0);
        break;
   //////////////////////////////////  CAP0.1(TIMER0)   ////////////////////////////////
   case CAP01_P04:
        PCB_PINSEL0 &= 0xFFFFF3FF;  		//Pin P0.4 como CAP0.1(Timer0)
        PCB_PINSEL0 |= 0x00000200; 
        T0CCR &= 0xFC7;
        T0CCR |= (mode << 3);
        break;
   case CAP01_P027:
        PCB_PINSEL1 &= 0xFF3FFFFF;  		//Pin P0.27 como CAP0.1(Timer0)
        PCB_PINSEL1 |= 0x00800000;	
        T0CCR &= 0xFC7;
        T0CCR |= (mode << 3);
        break;
   //////////////////////////////////  CAP0.2(TIMER0)   ////////////////////////////////
   case CAP02_P06:
        PCB_PINSEL0 &= 0xFFFFCFFF;  		//Pin P0.6 como CAP0.2(Timer0)
        PCB_PINSEL0 |= 0x00002000; 
        T0CCR &= 0xE3F;
        T0CCR |= (mode << 6);
        break;
   case CAP02_P016:                   
        PCB_PINSEL1 &= 0xFFFFFFFC;  		//Pin P0.16 como CAP0.2(Timer0)
        PCB_PINSEL1 |= 0x00000003;	
        T0CCR &= 0xE3F;
        T0CCR |= (mode << 6);
        break;
   case CAP02_P028:                   
        PCB_PINSEL1 &= 0xFCFFFFFF;  		//Pin P0.28 como CAP0.2(Timer0)
        PCB_PINSEL1 |= 0x02000000;	
        T0CCR &= 0xE3F;
        T0CCR |= (mode << 6);
        break;
   //////////////////////////////////  CAP0.3(TIMER0)   ////////////////////////////////
   case CAP03_P029:                   
        PCB_PINSEL1 &= 0xF3FFFFFF;  		//Pin P0.29 como CAP0.3(Timer0)
        PCB_PINSEL1 |= 0x08000000;	
        T0CCR &= 0x1FF;
        T0CCR |= (mode << 9);
        break;
   //////////////////////////////////  CAP1.0(TIMER1)   ////////////////////////////////
   case CAP10_P010:                   
        PCB_PINSEL0 &= 0xFFCFFFFF;  		//Pin P0.10 como CAP1.0(Timer1)
        PCB_PINSEL0 |= 0x00200000;	
        T1_CCR &= 0xFF8;
        T1_CCR |= (mode << 0);
        break;
   //////////////////////////////////  CAP1.1(TIMER1)   ////////////////////////////////
   case CAP11_P011:
        PCB_PINSEL0 &= 0xFF3FFFFF;  		//Pin P0.11 como CAP1.1(Timer1)
        PCB_PINSEL0 |= 0x00800000; 
        T1_CCR &= 0xFC7;
        T1_CCR |= (mode << 3);
        break;
   //////////////////////////////////  CAP1.2(TIMER1)   ////////////////////////////////
   case CAP12_P017:
        PCB_PINSEL1 &= 0xFFFFFFF3;  		//Pin P0.17 como CAP1.2(Timer1)
        PCB_PINSEL1 |= 0x00000004; 
        T1_CCR &= 0xE3F;
        T1_CCR |= (mode << 6);
        break;
   case CAP12_P019:                   
        PCB_PINSEL1 &= 0xFFFFFF3F;  		//Pin P0.19 como CAP1.2(Timer1) bits 6 y 7 en 11
        PCB_PINSEL1 |= 0x000000C0;	
        T1_CCR &= 0xE3F;
        T1_CCR |= (mode << 6);
        break;
   //////////////////////////////////  CAP1.3(TIMER1)   ////////////////////////////////
   case CAP13_P018:                   
        PCB_PINSEL1 &= 0xFFFFFFCF;  		//Pin P0.18 como CAP1.3(Timer1)
        PCB_PINSEL1 |= 0x00000010;	
        T1_CCR &= 0x1FF;
        T1_CCR |= (mode << 9);
        break;
   case CAP13_P021:                   
        PCB_PINSEL1 &= 0xFFFFF3FF;  		//Pin P0.21 como CAP1.3(Timer1)
        PCB_PINSEL1 |= 0x00000C00;	
        T1_CCR &= 0x1FF;
        T1_CCR |= (mode << 9);
        break;
  }//switch (cap_pin)

  if((cap_pin >= CAP00_P02) && (cap_pin <= CAP03_P029))     //Corresponde al TIMER0
  {
    if(mode & CAP_EVENT)
    {
      irq_vect_init(VIC_TIMER0, priority, (unsigned long) irq_timer0);
      irq_vect_enable(VIC_TIMER0);
    }
  }
  else if((cap_pin >= CAP10_P010) && (cap_pin <= CAP13_P021))
  {
    if(mode & CAP_EVENT)
    {
      irq_vect_init(VIC_TIMER1, priority, (unsigned long) irq_timer1);
      irq_vect_enable(VIC_TIMER1);
    }
  }
}//final de capture_init


void capture_reset(unsigned char cap_pin)
{
  switch (cap_pin)
  {
   //////////////////////////////////  CAP0.0(TIMER0)   ////////////////////////////////
   case CAP00_P02:                   
        PCB_PINSEL0 &= 0xFFFFFFCF;  		//Pin P0.2 como GPIO
        break;
   case CAP00_P022:
        PCB_PINSEL1 &= 0xFFFFCFFF;  		//Pin P0.22 como GPIO
        break;
   case CAP00_P030:
        PCB_PINSEL1 &= 0xCFFFFFFF;  		//Pin P0.30 como GPIO
        break;
   //////////////////////////////////  CAP0.1(TIMER0)   ////////////////////////////////
   case CAP01_P04:
        PCB_PINSEL0 &= 0xFFFFF3FF;  		//Pin P0.4 como GPIO
        break;
   case CAP01_P027:
        PCB_PINSEL1 &= 0xFF3FFFFF;  		//Pin P0.27 como GPIO
        break;
   //////////////////////////////////  CAP0.2(TIMER0)   ////////////////////////////////
   case CAP02_P06:
        PCB_PINSEL0 &= 0xFFFFCFFF;  		//Pin P0.6 como GPIO
        break;
   case CAP02_P016:                   
        PCB_PINSEL1 &= 0xFFFFFFFC;  		//Pin P0.16 como GPIO
        break;
   case CAP02_P028:                   
        PCB_PINSEL1 &= 0xFCFFFFFF;  		//Pin P0.28 como GPIO
        break;
   //////////////////////////////////  CAP0.3(TIMER0)   ////////////////////////////////
   case CAP03_P029:                   
        PCB_PINSEL1 &= 0xF3FFFFFF;  		//Pin P0.29 como GPIO
        break;
   //////////////////////////////////  CAP1.0(TIMER1)   ////////////////////////////////
   case CAP10_P010:                   
        PCB_PINSEL0 &= 0xFFCFFFFF;  		//Pin P0.10 como GPIO
        break;
   //////////////////////////////////  CAP1.1(TIMER1)   ////////////////////////////////
   case CAP11_P011:
        PCB_PINSEL0 &= 0xFF3FFFFF;  		//Pin P0.11 como GPIO
        break;
   //////////////////////////////////  CAP1.2(TIMER1)   ////////////////////////////////
   case CAP12_P017:
        PCB_PINSEL1 &= 0xFFFFFFF3;  		//Pin P0.17 como GPIO
        break;
   case CAP12_P019:                   
        PCB_PINSEL1 &= 0xFFFFFF3F;  		//Pin P0.19 como GPIO
        break;
   //////////////////////////////////  CAP1.3(TIMER1)   ////////////////////////////////
   case CAP13_P018:                   
        PCB_PINSEL1 &= 0xFFFFFFCF;  		//Pin P0.18 como GPIO
        break;
   case CAP13_P021:                   
        PCB_PINSEL1 &= 0xFFFFF3FF;  		//Pin P0.21 como GPIO
        break;
  }//switch (cap_pin)
}//final de capture_reset


int capture_get(unsigned char cap_pin)
{
  switch (cap_pin)
  {
    //////////////////////////////////  CAP0.0(TIMER0)   ////////////////////////////////
    case CAP00_P02:                   
      return T0CR0;
      break;
    case CAP00_P022:
      return T0CR0;  	
    case CAP00_P030:
      return T0CR0;  	
      //////////////////////////////////  CAP0.1(TIMER0)   ////////////////////////////////
    case CAP01_P04:
      return T0CR1;
    case CAP01_P027:
      return T0CR1;
      //////////////////////////////////  CAP0.2(TIMER0)   ////////////////////////////////
    case CAP02_P06:
      return T0CR2;
    case CAP02_P016:  
      return T0CR2;
      break;
    case CAP02_P028:
      return T0CR2;
      //////////////////////////////////  CAP0.3(TIMER0)   ////////////////////////////////
    case CAP03_P029: 
      return T0CR3;
      //////////////////////////////////  CAP1.0(TIMER1)   ////////////////////////////////
    case CAP10_P010:   
      return T1_CR0;
      //////////////////////////////////  CAP1.1(TIMER1)   ////////////////////////////////
    case CAP11_P011:
      return T1_CR1;
      //////////////////////////////////  CAP1.2(TIMER1)   ////////////////////////////////
    case CAP12_P017:
      return T1_CR2;
    case CAP12_P019:    
      return T1_CR2;
      //////////////////////////////////  CAP1.3(TIMER1)   ////////////////////////////////
    case CAP13_P018:    
      return T1_CR3;
    case CAP13_P021:    
      return T1_CR3;
  }//switch (cap_pin)
  return -1;
}////final de capture_get
//--------------------------------------------------TIMER-----------------------------------------------------------------------------
void timer_init(unsigned char timer, unsigned char match_n, char mode, unsigned char priority, int prescaler, int match)
{
  callbacks_timer1_match0 = timer_callbacks_error;
  callbacks_timer1_match1 = timer_callbacks_error;
  callbacks_timer1_match2 = timer_callbacks_error;
  callbacks_timer1_match3 = timer_callbacks_error;
  callbacks_timer0_match0 = timer_callbacks_error;
  callbacks_timer0_match1 = timer_callbacks_error;
  callbacks_timer0_match2 = timer_callbacks_error;
  callbacks_timer0_match3 = timer_callbacks_error;

   switch (timer)
  { 
    case TIMER0:
      T0PR = prescaler;
      T0MCR &= ~(7 << (3 * match_n));
      T0MCR |= (mode << (3 * match_n));
      (*(&(T0MR0) + match_n)) = match;        //Asigno match en el registro correpondiente (MR0, MR1, MR2 o MR3).
      if(mode & INTERRUPT_ON_MATCH)           //Habilitar interrupcion
      {
        irq_vect_init(VIC_TIMER0, priority, (unsigned long) irq_timer0);
        irq_vect_enable(VIC_TIMER0);
      }
      break;

     case TIMER1:
      T1_PR = prescaler;
      T1_MCR &= ~(7 << (3 * match_n));
      T1_MCR |= (mode << (3 * match_n));
      (*(&(T1_MR0) + match_n)) = match;        //Asigno match en el registro correpondiente (MR0, MR1, MR2 o MR3).
      if(mode & INTERRUPT_ON_MATCH)            //Habilitar interrupcion
      {
        irq_vect_init(VIC_TIMER1, priority, (unsigned long) irq_timer1);
        irq_vect_enable(VIC_TIMER1);
      }
      break;

     default:
      break;
  }//switch (timer)
}//final de timer_init

void timer_reset(unsigned char timer, unsigned char match_n)
{
  switch (timer)
  { 
    case TIMER0:
      T0MCR &= ~(7 << (3 * match_n));
      break;

    case TIMER1:
      T1_MCR &= ~(7 << (3 * match_n));
      break;

    default:
      break;
  }//switch (timer)
}//final de timer_reset

int timer_get(unsigned char timer, unsigned char contador)
{
  switch (timer)
  { 
    case TIMER0:
      switch (contador)
      {
        case TIMER_COUNTER: 
          return T0TC;
          break;
        case PRESCALER:
          return T0PR;
          break;
        case PRESCALER_COUNTER:
          return T0PC;
          break;
      }
      break;
    case TIMER1:
      switch (contador)
      {
        case TIMER_COUNTER: 
          return T1_TC;
          break;
        case PRESCALER:
          return T1_PR;
          break;
        case PRESCALER_COUNTER:
          return T1_PC;
          break;
      }
      break;
  }//switch (timer)
  return -1;
}////final de timer_get

void timer_mr0_mr1_enable(void)
{
  timer_flag = 1;
  if(T1_MR0 > T1_MR1)       //Siempre la mayor base de tiempo debe estar en el MATCH1.
  {
    T1_match0 = T1_MR1;
    T1_MR1 = T1_MR0;
    T1_MR0 = T1_match0;
  }
  else
  {
    T1_match0 = T1_MR0;
  }
  if((T1_MR0 >= T1_MR1 - 0x126) && (T1_MR0 <= T1_MR1 + 0x126))    //0x126 son 5uSeg
  {
    timer_flag = -1;
  }
}

void timer_mr0_mr1_disable(void)
{ 
  timer_flag = 0;
  timer_reset(TIMER1, TIMER_MATCH0);
  timer_reset(TIMER1, TIMER_MATCH1);
}

void timer_disable_interrupt(unsigned char timer, unsigned char match_n)
{
  switch (timer)
  { 
    case TIMER0:
      T0MCR &= ~(1 << (3 * match_n));
      break;

    case TIMER1:
      T1_MCR &= ~(1 << (3 * match_n));
      break;

    default:
      break;
  }//switch (timer)
}//final de timer_disable_interrupt

void timer_enable_interrupt(unsigned char timer, unsigned char match_n)
{
  switch (timer)
  { 
    case TIMER0:
      T0MCR |= (1 << (3 * match_n));
      break;

    case TIMER1:
      T1_MCR |= (1 << (3 * match_n));
      break;

    default:
      break;
  }//switch (timer)
}//final de timer_enable_interrupt

void irq_timer1(void)
{
  if ((INTERRUPT_T1MR0()) || ((timer_flag == -1) && (INTERRUPT_T1MR0())))//Bandera de interrupcion de MATCH0 del TIMER1
  {	
    T1MR0_CLRFLAG();      //Limpia la bandera de interrupcin del Match0.
    (*callbacks_timer1_match0)();
    if(timer_flag == 1)
    {
      if(T1_MR1 > (T1_MR0 + T1_match0))
      {
        T1_MR0 += T1_match0;
      }
      else
      {
        T1_MR0 = (T1_MR0 + T1_match0) - T1_MR1;
      }
    }
  }

  if((INTERRUPT_T1MR1()) || ((timer_flag == -1) && (INTERRUPT_T1MR1())))
  {
    T1MR1_CLRFLAG();
    (*callbacks_timer1_match1)();   //Llamo la funcion asignada a este puntero.
  }

  if(INTERRUPT_T1MR2())
  {
    T1MR2_CLRFLAG();
    (*callbacks_timer1_match2)();   //Llamo la funcion asignada a este puntero.
  }

  if(INTERRUPT_T1MR3())
  {
    T1MR3_CLRFLAG();
    (*callbacks_timer1_match3)();   //Llamo la funcion asignada a este puntero.
  }
    if (CAPTURE10_EVEN())
  {
    CAPTURE10_CLRFLAG();
    (*callbacks_timer1_capture0)();
  }
  if (CAPTURE11_EVEN())
  {
    CAPTURE11_CLRFLAG();      
    (*callbacks_timer1_capture1)();
  }
  if (CAPTURE12_EVEN())
  {
    CAPTURE12_CLRFLAG();   
    (*callbacks_timer1_capture2)();
  }
  if (CAPTURE13_EVEN())
  {
    CAPTURE13_CLRFLAG();   
    (*callbacks_timer1_capture3)();
  }
VICVectAddr = 0x00;//Escritura que seala el fin de la interrupcion
}//final de irq_timer1

void irq_timer0(void)
{
   if (INTERRUPT_T0MR0())
  {	
    T0MR0_CLRFLAG();      //Limpia la bandera de interrupcin del Match0.
    (*callbacks_timer0_match0)();   //Llamo la funcion asignada a este puntero.
  }

  if(INTERRUPT_T0MR1())
  {
    T0MR1_CLRFLAG();
    (*callbacks_timer0_match1)();   //Llamo la funcion asignada a este puntero.
  }

  if(INTERRUPT_T0MR2())
  {
    T0MR2_CLRFLAG();
    (*callbacks_timer0_match2)();   //Llamo la funcion asignada a este puntero.
  }

  if(INTERRUPT_T0MR3())
  {
    T0MR3_CLRFLAG();
    (*callbacks_timer0_match3)();   //Llamo la funcion asignada a este puntero.
  }
  if (CAPTURE00_EVEN())
  {
    CAPTURE00_CLRFLAG();
    (*callbacks_timer0_capture0)();
  }
  if (CAPTURE01_EVEN())
  {
    CAPTURE01_CLRFLAG();      
    (*callbacks_timer0_capture1)();
  }
  if (CAPTURE02_EVEN())
  {
    CAPTURE02_CLRFLAG();   
    (*callbacks_timer0_capture2)();
  }
  if (CAPTURE03_EVEN())
  {
    CAPTURE03_CLRFLAG();   
    (*callbacks_timer0_capture3)();
  }

  VICVectAddr = 0x00;//Escritura que seala el fin de la interrupcion
}
void timer_callbacks_error()
{
  //Si se ejecuta esta funcion es que se esta entrando en un callback no definido en el programa.
}
