/* Escribir sobre la uart mediante polling */
#include "uart.h"

/* ----------------------------------------------------------------------------
 * inicializar UART
 * ----------------------------------------------------------------------------*/
void UART_Init()
{
   PCB_PINSEL0 |= 0x00000005;     
   UART0_IER = 0x00;             // Deshabilita todas las interrupciones
   UART0_IIR;             // Borrar identificaciones de interrupciones
   UART0_LSR;             // Borra el "line status register"
   UART0_RBR;             // Borra el "receive register"
   
  /* configurar el baud rate a 9600 baudios */
  UART_BaudRateConfig(UART_BAUD(9600));
  /* Configuración del registro de control */
  UART0_LCR = 0x03; /* 00000011 8 bits sin paridad y 1 bit de stop */
  /* Configuración de la FIFO */
  UART0_FCR = 0x07; /* 00000111 activar fifo, reset de fifo Tx y Rx, trigger FIFO Rx = 1 caracter */
 }
/* ----------------------------------------------------------------------------
 * inicializar Baud Rate
 * ----------------------------------------------------------------------------*/
void UART_BaudRateConfig(unsigned int BaudRate)
{
   UART0_LCR |= (1<<7);               //DLAB en 1;
   UART0_DLL = (unsigned char) (BaudRate >> 0);
   UART0_DLM = (unsigned char) (BaudRate >> 8);
   UART0_LCR &= ~(1<<7);              //DLAB en 0;
}
/* ----------------------------------------------------------------------------
 * enviar un byte
 * ----------------------------------------------------------------------------*/
void UART_ByteSend(unsigned char Data)
{
  if (((UART0_FCR >> 0) & 1) == 1)  {      //Si la FIFO está habilitada.
    while(((UART0_LSR >> 5) & 1) == 0);    //Esperar hasta que al menos 1 posición de la FIFO esté libre.
  } else {                                 //Si la FIFO no está habilitada.
    while(((UART0_LSR >> 6) & 1) == 0);    //Esperar hasta que el shift register del transmisor esté vacío.
  }
  UART0_THR = Data;
}

/* ----------------------------------------------------------------------------
 * recibir un byte
 * ----------------------------------------------------------------------------*/
unsigned char UART_ByteReceive()
{
  while((UART0_LSR >> 0) == 0);               //Esperar hasta que haya un dato disponible.
  return (UART0_RBR);                         //Retorna el caracter.
}
