#include "vumetro.h"


void vumetro_init() 
{


	PCB_PINSEL0 &= 0XF3F3FFFF; //Configuro los Pines P0.9 P0.13 
	PCB_PINSEL1 &= 0XFFF00000; //Configuro los Pines P0.16 - P0.25 como GPIO.
	PCB_PINSEL2 &= 0xFFFFFFF3;	//Configuro Pines P1.16 - P1-31 como GPIO. 
	
	IODIR0 |= 0X03FF2200;	//Configuro P0.9, P0.13, P0.16 - P0.25 como salida.
	IODIR1 |= 0x00FF0000;	//Configuro P1-16 - P1.23.
	
	IOCLR1 |= 0x00FF0000;	//Pone las salidas a masa.
	IOCLR0 |= 0X03FF2200;	//Pone las salidas a masa.
		
	
}

void vumetro(UINT val, UINT canal) 
{
	if (val == 0){
		switch (canal){
			case 0:
				IOCLR0 |= 0X03012200;
				break;
			case 1:
				IOCLR0 |= 0X003E0000;
				break;
			case 2:
				IOCLR0 |= 0X00C00000;
				IOCLR1 |= 0X00070000;
				break;
			case 3:
				IOCLR1 |= 0X00F80000;
				break;
			default:
				break;
		}	
	}
	if ((1 < val) && (val <= 2)){
		switch (canal){
			case 0:
				IOCLR0 |= 0X03012200;
				IOSET0 |= 0x00010000; 
				break;
			case 1:
				IOCLR0 |= 0X003E0000;
				IOSET0 |= 0X00200000;
				break;
			case 2:
				IOCLR0 |= 0X00C00000;
				IOCLR1 |= 0X00070000;
				IOSET1 |= 0X00040000;
				break;
			case 3:
				IOCLR1 |= 0X00F80000;
				IOSET1 |= 0X00800000;
				break;
			default:
				break;
		}							//Fin de Switch Case
	}else{
		if((2 < val) && (val <= 4))
		{
			switch (canal){
				case 0:
				IOCLR0 |= 0X03012200;
				IOSET0 |= 0x00012000; 
				break;
			case 1:
				IOCLR0 |= 0X003E0000;
				IOSET0 |= 0X00300000;
				break;
			case 2:
				IOCLR0 |= 0X00C00000;
				IOCLR1 |= 0X00070000;
				IOSET1 |= 0X00060000;
				break;
			case 3:
				IOCLR1 |= 0X00F80000;
				IOSET1 |= 0X00C00000;
				break;
			default:
				break;
			}					//Fin de Switch Case
		}else{
			if((4 < val) && (val <= 10)){
				switch (canal){
					case 0:
						IOCLR0 |= 0X03012200;
						IOSET0 |= 0x00012200; 
						break;
					case 1:
						IOCLR0 |= 0X003E0000;
						IOSET0 |= 0X00380000;
						break;
					case 2:
						IOCLR0 |= 0X00C00000;
						IOCLR1 |= 0X00070000;
						IOSET1 |= 0X00070000;
						break;
					case 3:
						IOCLR1 |= 0X00F80000;
						IOSET1 |= 0X00E00000;
						break;
					default:
						break;
				}				//Fin de Switch Case
			}else{
				if((10 < val) && (val <= 35)){
					switch (canal){
						case 0:
							IOCLR0 |= 0X03012200;
							IOSET0 |= 0x02012200; 
							break;
						case 1:
							IOCLR0 |= 0X003E0000;
							IOSET0 |= 0X003C0000;
							break;
						case 2:
							IOCLR0 |= 0X00C00000;
							IOCLR1 |= 0X00070000;
							IOSET1 |= 0X00070000;
							IOSET0 |= 0X00800000;
							break;
						case 3:
							IOCLR1 |= 0X00F80000;
							IOSET1 |= 0X00F00000;
							break;
						default:
							break;
					}					//Fin de Switch Case
				}else{
					if((35 < val) && (val <= 100)){
						switch (canal){
							case 0:
								IOCLR0 |= 0X03012200;
								IOSET0 |= 0x03012200; 
								break;
							case 1:
								IOCLR0 |= 0X003E0000;
								IOSET0 |= 0X003E0000;
								break;
							case 2:
								IOCLR0 |= 0X00C00000;
								IOCLR1 |= 0X00070000;
								IOSET1 |= 0X00070000;
								IOSET0 |= 0X00C00000;
								break;
							case 3:
								IOCLR1 |= 0X00F80000;
								IOSET1 |= 0X00F80000;
								break;
							default:
								break;
						}					//Fin de Switch Case
					}
				
				}
			}
		}
	}
}

void vumetro_set(){
	IOSET1 |= 0x00FF0000;	//Pone las salidas a masa.
	IOSET0 |= 0X03FF2200;	//Pone las salidas a masa.
}

void vumetro_clr(){
	IOCLR1 |= 0x00FF0000;	//Pone las salidas a masa.
	IOCLR0 |= 0X03FF2200;	//Pone las salidas a masa.
}
