/* ESTE PROGRAMA UTILIZA EL MODULO CAPTURE Y ENVIA POR UART LA DIFERENCIA ENTRE CAPTURAS  */

#include "lpc2114.h"
#include "uart.h"
#include <stdio.h>

#define TIMER_MATCH0 (1<<0)

#define INTERRUPT_ON_MATCH (1<<0)
#define RESET_ON_MATCH (1<<1)

void fiq_handler (void) __attribute__ ((interrupt("FIQ")));
void irq_handler (void) __attribute__ ((interrupt("IRQ")));;

//---------Variables Globales ------------------//

signed int count;
int contador;

int main(void)
{
  char cadena[20];
  count = 0;

  T0PR = 0;   		// prescaler = 0 
  T0TCR = 0x02;		// reset timer counter y prescaler en le prox ciclo pckl
 
  // registros correspondiente al MATCH0 = T0MCR(0:2) y T0MR0
  T0MCR &= 0xFF8;
  T0MCR |= ((INTERRUPT_ON_MATCH | RESET_ON_MATCH) << 0); // configuracin = interrumpir y reset al llegar a cuenta
  T0MR0 = 0x24000;  	// cuenta a llegar (10ms)

  T0TCR = 0x1;    	// Timer Counter y Preescaler Counter habilitados para contar (TIMER0)

  VICIntSelect |= (1 << 4); // habilitar interrupcion para FIQ

  VICIntEnable |= (1 << 4); // habilitar la interrupcin del Timer0(4)


 //------------Configuracin de la UART0 ---------------//
  UART_Init();
  UART_BaudRateConfig(UART_BAUD(9600));

  //-------------------Configuracin de Capture del Timer0----------------------//
  //Configura el Pin P0.2 como CAP0.0, FASE A del Encoder1

  int i;

  while(1) 
  {
    for (i=0; i <= 100000;i++);
    sprintf(cadena,"Salida: %d",contador);
  }//fin bucle principal
}//fin de main

void fiq_handler (void)
{
  contador++;	
  T0IR = TIMER_MATCH0; 
  return;
}


