
#include "lpc2114.h"
#include "led.h"

#define TIMER_MATCH0 (1<<0)

#define INTERRUPT_ON_MATCH (1<<0)
#define RESET_ON_MATCH (1<<1)

// ----------------------------------------------------------------------------
// Macros de entrada y salida de interrupciones 
//
// La entrada y salida de una funcin de interrupcin, es automticamente creada
// por el compilador, indicndole est caracterstica mediante  
// __attribute__ ((interrupt)). 
void irq_timer0 (void) __attribute__ ((interrupt("IRQ")));;
// ----------------------------------------------------------------------------

static const int led_value[2] = {0x55, 0xAA};
int contador;
//-----------------------------------------------------------------------------
// main
//-----------------------------------------------------------------------------
int main(void)
{
  // configuracin del timer 0 
  
  T0PR = 0;   		// prescaler = 0 
  T0TCR = 0x02;		// reset timer counter y prescaler en le prox ciclo pckl
 
  // registros correspondiente al MATCH0 = T0MCR(0:2) y T0MR0
  T0MCR &= 0xFF8;
  T0MCR |= ((INTERRUPT_ON_MATCH | RESET_ON_MATCH) << 0); // configuracin = interrumpir y reset al llegar a cuenta
  T0MR0 = 0x24000;  	// cuenta a llegar (10ms)

  T0TCR = 0x1;    	// Timer Counter y Preescaler Counter habilitados para contar (TIMER0)

  // configurar interrupciones 
  // se utiliza la opcin vectorizada de IRQ

  VICVectCntl0 = 4; 	// fuente de interrupcin Timer0(4)
  VICVectCntl0 |= 0x20; // habilitar la fuente de interrupcin  
  VICVectAddr0 = (unsigned long) irq_timer0; // asignar el puntero de la funcin que atiende la interrupcin timer0

  VICIntEnable |= (1 << 4); // habilitar la interrupcin del Timer0(4)

  led_init();
  while(1) {
    led(led_value[0]);
    contador = 0;
    while(contador<50); // bucle que espera que 50 interrupciones del timer 0 
    led(led_value[1]);
    contador = 0;
    while(contador<50); // bucle que espera que 50 interrupciones del timer 0 
  }
  return 0; 
}
//---------------------------------------------------------------------------------------------------------------------------------------
// funcin de interrupcin para el timer 0 
//---------------------------------------------------------------------------------------------------------------------------------------
void irq_timer0(void)
{
  if( T0IR & TIMER_MATCH0)      // verifica que el llamado a la interrupcin est efectuado por el match0
  {
    contador++;  
    T0IR = TIMER_MATCH0; 	// borrar la bandera de interrupcin del match canal 0
  }
  VICVectAddr = 0x00;           // Escritura boba que seala el fin de una interrupcin	irq_timer0();
}

