#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

int main(int argc, char * argv[])
{
  int opt;
  int flag = 0;


  /* [option <argument>]
     the colon indicates that the option has an associated value. */
  while( (opt = getopt(argc, argv, "i:f:s:bh")) != -1)
  {
    switch(opt)
    {
      case 'i': /* int */
        printf("Integer: %d\n", atoi(optarg));
        break;
      case 'f': /* float */
        printf("Real: %.2f\n", atof(optarg));
        break;
      case 's': /* string */
        printf("String: %s\n", optarg);
        break;
      case 'b': /* boolean: flag */
        flag = 1;
        printf("Flag 0 -> %d\n", flag);
        break;
      case 'h': /* help */
        printf("USAGE: %s [option <argument>]\n", argv[0]);
        printf("   Where [option] can be:\n");
        printf("      -i <int>    : integer value\n");
        printf("      -f <float>  : float value\n");
        printf("      -s <string> : string\n");
        printf("      -b          : flag\n");
        printf("      -h          : this help\n");
        break;
    }
  }

  return 0;
}
