#include <stdio.h>  /* Standard input / output definitions */
#include <unistd.h> /* UNIX standard function definitions */
#include <fcntl.h>  /* File control definitions */
#include <string.h>

int main(int argc, char * argv[])
{
  int fd ;          /* File descriptor for the port */

  if(argc != 3)
  {
    printf("USAGE: %s <port> <message>\n", argv[0]);
    return -1;
  }

  fd = open(argv[1], O_WRONLY | O_NOCTTY | O_NDELAY);
  if(fd == -1)
  {
    printf("ERROR: opening the port\n");
    return -1;
  }

  write(fd, argv[2], strlen(argv[2]));

  close(fd);
  return 0;
}

