/* -------------------- Inclusiones de mdulos externos --------------------*/


#include "motores.h"
#include "eduromaa.h"

/* FUNCION PRINCIPAL, PUNTO DE ENTRADA AL PROGRAMA LUEGO DE RESET. */
int main(void){

	/* ------------- INICIALIZACIONES ------------- */


	/*--------------------------------------------------------------------------
	 * Inicializar la placa:
	 * Los proyectos que vamos a utilizar ya tienen las configuraciones de
	 * entradas, salidas y perifricos de comunicacin correctamente realizadas
	 * como parte de la abstraccin.
    ------------------------------------------------------------------------ */
	init_eduromaa();


	/* ------------- REPETIR POR SIEMPRE ------------- */
	while(1) {

		estoy_vivo();	// Qu hace esta funcin?

		if ( gpioRead( BUMPER_IZQ ) ){
			gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
			gpioWrite( GPIO_MOTOR_IZQ_DIR, MOTOR_AVANZA );
			gpioWrite( GPIO_MOTOR_DER_DIR, MOTOR_AVANZA );
			pwmWrite( PWM_MOTOR_IZQ, 255 );
			pwmWrite( PWM_MOTOR_DER, 102 );
			delay(2000);
		}
		if ( gpioRead( BUMPER_DER ) ){
			gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
			gpioWrite( GPIO_MOTOR_IZQ_DIR, MOTOR_AVANZA );
			gpioWrite( GPIO_MOTOR_DER_DIR, MOTOR_AVANZA );
			pwmWrite( PWM_MOTOR_IZQ, 102 );
			pwmWrite( PWM_MOTOR_DER, 255 );
			delay(2000);
		}

		if ( !gpioRead( TEC1 ) ){
			gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
			gpioWrite( GPIO_MOTOR_IZQ_DIR, MOTOR_AVANZA );
			gpioWrite( GPIO_MOTOR_DER_DIR, MOTOR_AVANZA );
			pwmWrite( PWM_MOTOR_IZQ, 255 );
			pwmWrite( PWM_MOTOR_DER, 255 );
			delay(2000);
		}

		if ( !gpioRead( TEC2 ) ){
			gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
			gpioWrite( GPIO_MOTOR_IZQ_DIR, MOTOR_REVERSA );
			gpioWrite( GPIO_MOTOR_DER_DIR, MOTOR_REVERSA );
			pwmWrite( PWM_MOTOR_IZQ, 255 );
			pwmWrite( PWM_MOTOR_DER, 255 );
			delay(2000);
		}


		if ( !gpioRead( TEC3 ) ){
			gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
			gpioWrite( GPIO_MOTOR_IZQ_DIR, MOTOR_REVERSA );
			gpioWrite( GPIO_MOTOR_DER_DIR, MOTOR_AVANZA );
			pwmWrite( PWM_MOTOR_IZQ, 127 );
			pwmWrite( PWM_MOTOR_DER, 127 );
			delay(4000);
		}

		if ( !gpioRead( TEC4 ) ){
			gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
			gpioWrite( GPIO_MOTOR_IZQ_DIR, MOTOR_AVANZA );
			gpioWrite( GPIO_MOTOR_DER_DIR, MOTOR_REVERSA );
			pwmWrite( PWM_MOTOR_IZQ, 255 );
			pwmWrite( PWM_MOTOR_DER, 255 );
			delay(2000);
		}



		/* delayRead retorna TRUE cuando se cumple el tiempo de retardo */
		gpioWrite( GPIO_MOTOR_INH, MOTOR_DESHABILITA );
		pwmWrite( PWM_MOTOR_IZQ, 0 );
		pwmWrite( PWM_MOTOR_DER, 0 );

		/* Por qu utilizamos retardos bloqueantes en este ejemplo? Qu beneficio tiene?
		 * Qu dificultades presentara la implementacin de retardos no bloqueantes?
		 * */

	}

	/* Esta instruccin no debera ejecutarse, ya que el programa nunca sale del lazo "while(1)" */
	return 0 ;
}
