/* -------------------- Inclusiones de modulos externos --------------------*/


#include "eduromaa.h"
#include "motores.h"

/* FUNCION PRINCIPAL, PUNTO DE ENTRADA AL PROGRAMA LUEGO DE RESET. */
int main(void){

	/* ------------- INICIALIZACIONES ------------- */

	/* Variable de Retardo NO bloqueante */
	delay_t retardoEstado;


	/* Tiempos de retardos para recorrido cuadrado (en milisegundos) */
	uint64_t tiempo_avance=3000; 	//Por qu usamos este tipo de dato?

	/* En este momento el tiempo de giro para lograr un ngulo de 90 es estimado
	 * experimentalmente y depende principalmente de la velocidad de giro y la
	 * rugosidad de la superficie sobre la que se desplaza el robot
	 */
	uint64_t tiempo_giro=375;


	/* Variables de estado de los bumpers */
	uint8_t bump_izq = 0, bump_der = 0;

	/* Las funciones set_vel_lin(...) y set_vel_giro(...) reciben un valor entero
	 * entre -100 y 100 que representa un porcentaje de la velocidad mxima.
	 * Este nmero es equivalente al ciclo de trabajo de la seal PWM. Para
	 * la velocidad lineal un valor positivo implica avanzar y uno negativo
	 * retroceder. Para la velocidad de rotacin un valor positivo implica un giro
	 * en sentido horario y el negativo en sentido antihorario. */
	int8_t vel = 80;

	/* Variable de estado del robot. Indica sobre qu cara o vrtice del cuadrado
	 * se est desplazando. El valor centinela -1 indica que el robot est detenido,
	 * ya sea porque todava no inici o porque ya termin el ciclo.
	 * */
	int8_t estado=-1;

	/*--------------------------------------------------------------------------
	 * Inicializar la placa:
	 * Los proyectos que vamos a utilizar ya tienen las configuraciones de
	 * entradas, salidas y perif�ricos de comunicaci�n correctamente realizadas
	 * como parte de la abstracci�n.
    ------------------------------------------------------------------------ */
	init_eduromaa();

	delayConfig( &retardoEstado, tiempo_avance);


	/* ------------- REPETIR POR SIEMPRE ------------- */
	while(1) {

		estoy_vivo();

		/* Qu inconvenientes presenta este cdigo?
		 * Por qu cuando est activo algn bumper el buzzer no oscila?
		 * Analizar alternativa en archivo eduromaa/bumpers.c
		 * */
		bump_izq=gpioRead( BUMPER_IZQ );
		bump_der=gpioRead( BUMPER_DER );

		while(( bump_izq == 1) || (bump_der == 1)){
			set_vel_lin(0);
			bump_izq=gpioRead( BUMPER_IZQ );
			bump_der=gpioRead( BUMPER_DER );
			emergencia(EMG_BUZZ);
		}
		emergencia(EMG_OK);

		if(estado != -1){
			/* delayRead retorna TRUE cuando se cumple el tiempo de retardo */
			if ( delayRead( &retardoEstado ) ){
				set_vel_lin(0);
				delay(500);
				estado++;
			}
		}

		/* Al presionar TEC1 debe iniciarse el ciclo */
		if(!gpioRead(TEC1)){
			estado = 0;
		}

		switch(estado){
		case 0:
			delayWrite( &retardoEstado, tiempo_avance );
			set_vel_lin(-vel);
			break;
		case 1:
			delayWrite( &retardoEstado, tiempo_giro);
			set_vel_giro(-vel);
			break;
		case 2:
			delayWrite( &retardoEstado, tiempo_avance );
			set_vel_lin(-vel);
			break;
		case 3:
			delayWrite( &retardoEstado, tiempo_giro);
			set_vel_giro(-vel);
			break;
		case 4:
			delayWrite( &retardoEstado, tiempo_avance );
			set_vel_lin(-vel);
			break;
		case 5:
			delayWrite( &retardoEstado,tiempo_giro );
			set_vel_giro(-vel);
			break;
		case 6:
			delayWrite( &retardoEstado, tiempo_avance );
			set_vel_lin(-vel);
			break;
		case 7:
			delayWrite( &retardoEstado, tiempo_giro );
			set_vel_giro(-vel);
			break;
		case 8:
			set_vel_lin(0);
			estado =-1;
			break;
		default:
			set_vel_lin(0);
			estado =-1;
			break;
		}
	}


	/* Esta instruccin no debera ejecutarse, ya que el programa nunca sale del lazo "while(1)" */
	return 0 ;
}
