/* -------------------- Inclusiones de modulos externos --------------------*/
#include "sapi.h"       // <= sAPI header
#include "eduromaa.h"

/* FUNCION PRINCIPAL, PUNTO DE ENTRADA AL PROGRAMA LUEGO DE RESET. */
int main(void){

	/* ------------- INICIALIZACIONES ------------- */


	delay_t delay_ir;
	uint16_t ir_der, ir_izq; //Por qu utilizamos este tipo de dato?

	/* Inicializar la placa */

	init_eduromaa();

	delayConfig(&delay_ir,1000);
	adcConfig(ADC_ENABLE);

	/* ------------- REPETIR POR SIEMPRE ------------- */
	while(1) {
		estoy_vivo();

		if( delayRead( &delay_ir ) ){

			ir_izq = adcRead(CH1);	// Canal conectado a IR izquierdo

			ir_der = adcRead(CH2);	// Canal conectado a IR derecho

			print("CHIzq: ");
			print_int(ir_izq);
			print("\tCHDer: ");
			print_int(ir_der);
			println("");
		}
	}
	/* NO DEBE LLEGAR NUNCA AQUI, debido a que a este programa no es llamado
      por ningun S.O. */
	return 0 ;
}

/*==================[end of file]============================================*/
