/* -------------------- Inclusiones de modulos externos --------------------*/

#include "sapi.h"       // <= sAPI header
#include "eduromaa.h"
#include "sapi_ultrasonic_hcsr04.h"

/* FUNCION PRINCIPAL, PUNTO DE ENTRADA AL PROGRAMA LUEGO DE RESET. */
int main(void){

	/* ------------- INICIALIZACIONES ------------- */

	/* Variable de Retardo NO bloqueante */
	delay_t delay_ir;

	/* Variables de configuracin de velocidad */
	int8_t vel_alta = 80;
	int8_t vel_baja = 40;

	/* Inicializar la placa */
	init_eduromaa();

	/* Inicializar el sensor ultrasonico #0 */
	ultrasonicSensorConfig(ULTRASONIC_SENSOR_0, ULTRASONIC_SENSOR_ENABLE);

	/* Inicializacin de retardo NO bloqueante */
	delayConfig(&delay_ir,100);

	/* ------------- REPETIR POR SIEMPRE ------------- */
	while(1) {
		estoy_vivo();

		if( ultrasonicSensorGetDistance(ULTRASONIC_SENSOR_0, CM) >= 10.0 ){
			emergencia(EMG_OK);
			switch(seguir_linea()){
				case LINEA_ADELANTE:
					gpioWrite(LED1,OFF);
					gpioWrite(LED2,ON);
					gpioWrite(LED3,OFF);
					/* Motores: ambos avanzan a la misma velocidad */
					set_vel_der(vel_alta);
					set_vel_izq(vel_alta);
					break;
				case LINEA_GIRAR_DER:
					gpioWrite(LED1,OFF);
					gpioWrite(LED2,OFF);
					gpioWrite(LED3,ON);
					/* Motores: motor izquierdo avanza a mayor velocidad que el derecho */
					set_vel_der(vel_baja);
					set_vel_izq(vel_alta);
					break;
				case LINEA_GIRAR_IZQ:
					gpioWrite(LED1,ON);
					gpioWrite(LED2,OFF);
					gpioWrite(LED3,OFF);
					/* Motores: motor derecho avanza a mayor velocidad que el izquierdo */
					set_vel_der(vel_alta);
					set_vel_izq(vel_baja);
					break;
				case LINEA_DETENER:
				default:
					gpioWrite(LED1,OFF);
					gpioWrite(LED2,OFF);
					gpioWrite(LED3,OFF);
					/* Motores: ambos motores se detienen */
					set_vel_der(0);
					set_vel_izq(0);
					break;
			}
		}
		else{
			gpioWrite(LED1,ON);
			gpioWrite(LED2,ON);
			gpioWrite(LED3,ON);
			set_vel_der(0);
			set_vel_izq(0);
			emergencia(EMG_BUZZ);
		}
	}

	/* NO DEBE LLEGAR NUNCA AQUI, debido a que a este programa no es llamado
	por ningun S.O. */
	return 0 ;
}

/*==================[end of file]============================================*/
