#ifndef _LAB2_H_
#define _LAB2_H_

/*==================[inclusiones]=============================================*/
#include "sapi.h"              // Libreras sAPI, las vamos a usar en todos los proyectos

#include "bumpers.h"
#include "comunicacion.h"
#include "motores.h"
#include "ir_linea.h"
#include "bluetooth.h"
#include "odometria.h"


/*==================[definiciones]================================================*/

#define PWM_BUZZ PWM6	// GPIO8

#define EMG_OK		0U
#define EMG_BUZZ 	1U

uint8_t buzz = 0;
uint8_t estado_emg = 0;
delay_t retardo_vivo;

void init_testigo(void)
{
	// Buzzer para alertas
	pwmConfig( 0, PWM_ENABLE);	// Habilitacin General
	pwmConfig(PWM_BUZZ, PWM_ENABLE_OUTPUT); // Configuracin de Salida en GPIO8
	pwmWrite( PWM_BUZZ, 0);		// Apagado por defecto

	// Retardo para LED Testigo
	delayConfig( &retardo_vivo, 1000 );
}

void init_eduromaa(void){

	boardConfig();

	init_testigo();

	init_bumpers();

	init_usb_com();

	init_motores();

	init_linea();

	init_BT();

	init_odometria();
}

void emergencia(uint8_t num_emg){

	if (estado_emg != num_emg){
		estado_emg = num_emg;

		switch (estado_emg){
		case EMG_BUZZ:
			buzz = 0xFF;
			break;
		default:
			buzz = 0;
			break;
		}
		pwmWrite( PWM_BUZZ, buzz);
	}
}

void estoy_vivo(void)
{

	comunicate();

	if ( delayRead( &retardo_vivo ) ){
		gpioToggle(LEDR);

		if (estado_emg == EMG_BUZZ){
			buzz = ~buzz;
			pwmWrite( PWM_BUZZ, buzz);
		}
	}
}


/*==================[end of file]============================================*/
#endif /* #ifndef _MOTORES_H_ */
