/*==================[inclusiones]=============================================*/
#include "ir_linea.h"
#include "comunicacion.h"


/*==================[definiciones]================================================*/

ir_sensor_t ir_izq = {0, LINEA_UMBRAL, LINEA_HISTERESIS, LINEA_NEGRO, CANAL_LINEA_IZQ};
ir_sensor_t ir_der = {0, LINEA_UMBRAL, LINEA_HISTERESIS, LINEA_NEGRO, CANAL_LINEA_DER};

/*==================[Funciones publicas]======================================*/

int init_linea(void){
	adcConfig(ADC_ENABLE);
	return 1;
}

bool_t actualizar_ir_sensor(ir_sensor_t *ir_sensor){
	ir_sensor->value = adcRead(ir_sensor->channel);

	print_int(ir_sensor->channel);
	print(" CH\t");
	print_int(ir_sensor->value);
	print(" Val\t");


	if(ir_sensor->state == LINEA_NEGRO){			// ltimo estado NEGRO
		if(ir_sensor->value < (ir_sensor->threshold - ir_sensor->hysteresis /2)){
			ir_sensor->state = LINEA_BLANCO;
		}
	}
	else{											// ltimo estado BLANCO
		if(ir_sensor->value > (ir_sensor->threshold + ir_sensor->hysteresis /2)){
			ir_sensor->state = LINEA_NEGRO;
		}
	}
	print_int(ir_sensor->state);
	println(" St");
	return ir_sensor->state;
}

bool_t leer_sensor_ir(uint8_t ir_sensor_id){
	bool_t resultado = FALSE;
	switch (ir_sensor_id){				// Se utiliza un switch case por si se quieren agregar ms sensores
		case LINEA_ID_IZQUIERDA:
			actualizar_ir_sensor(&ir_izq);
			resultado = ir_izq.state;
			break;
		case LINEA_ID_DERECHA:
			actualizar_ir_sensor(&ir_der);
			resultado = ir_der.state;
			break;
		default:
			break;
	}
	return resultado;
}

uint8_t seguir_linea(void){
	uint8_t accion = LINEA_DETENER;
	if(actualizar_ir_sensor(&ir_izq) == LINEA_COLOR){
		accion += LINEA_GIRAR_IZQ;
	}
	if(actualizar_ir_sensor(&ir_der) == LINEA_COLOR){
		accion += LINEA_GIRAR_DER;
	}
	return accion;
}

