/* -------------------- Inclusiones de mdulos externos --------------------*/

#include "sapi.h"              // Libreras sAPI, las vamos a usar en todos los proyectos

/* FUNCION PRINCIPAL, PUNTO DE ENTRADA AL PROGRAMA LUEGO DE RESET. */
int main(void){
	/* Variable de Retardo no bloqueante */
	delay_t retardoTEC1, retardoTEC2;


	/* ------------- INICIALIZACIONES ------------- */

	/*--------------------------------------------------------------------------
	 * Inicializar la placa:
	 * Los proyectos que vamos a utilizar ya tienen las configuraciones de
	 * entradas, salidas y perifricos de comunicacin correctamente realizadas
	 * como parte de la abstraccin.
    ------------------------------------------------------------------------ */
	boardConfig();


	/* ------------- REPETIR POR SIEMPRE ------------- */
	while(1) {

		/* Lectura de estado de las teclas */
		if ( !gpioRead( TEC1 ) ){
			gpioWrite( LED1, ON );
			delayConfig( &retardoTEC1, 2000 );
		}
		if ( !gpioRead( TEC2 ) ){
			delayConfig( &retardoTEC2, 2000 );
			gpioWrite( LED2, ON );
		}

		/* Mtodo NO bloqueante para retardar un evento:
		 * delayRead(...) retorna TRUE cuando se cumple el tiempo de retardo */
		if ( delayRead( &retardoTEC1 ) ){
			gpioWrite( LED1, OFF );
		}
		if ( delayRead( &retardoTEC2 ) ){
			gpioWrite( LED2, OFF );

		}


	}

	/* Esta instruccin no debera ejecutarse, ya que el programa nunca sale del lazo "while(1)" */
	return 0 ;
}
