/* -------------------- Inclusiones de mdulos externos --------------------*/

#include "eduromaa.h"

/* FUNCION PRINCIPAL, PUNTO DE ENTRADA AL PROGRAMA LUEGO DE RESET. */
int main(void){

	/* ------------- INICIALIZACIONES ------------- */

	uint8_t bt_dato = 0;
	int8_t 	vel_lin = 80;
	int8_t	vel_giro = 50;


	/*--------------------------------------------------------------------------
	 * Inicializar la placa:
	 * Los proyectos que vamos a utilizar ya tienen las configuraciones de
	 * entradas, salidas y perifricos de comunicacin correctamente realizadas
	 * como parte de la abstraccin.
    ------------------------------------------------------------------------ */
	init_eduromaa();

	/* ------------- REPETIR POR SIEMPRE ------------- */
	while(1) {
		estoy_vivo();
		if(leer_BT(&bt_dato)){
			switch(bt_dato){
			case BT_AVANZAR:
				set_vel_lin(vel_lin);
				break;
			case BT_RETROCEDER:
				set_vel_lin(-vel_lin);
				break;
			case BT_GIRAR_IZQ:
				set_vel_giro(-vel_giro);
				break;
			case BT_GIRAR_DER:
				set_vel_giro(vel_giro);
				break;
			case BT_DETENER:
				set_vel_lin(0);
				break;
			default:
				break;

			}
		}
	}


	/* Esta instruccin no debera ejecutarse, ya que el programa nunca sale del lazo "while(1)" */
	return 0 ;
}
