#ifndef _BUMPERS_H_
#define _BUMPERS_H_

/*==================[inclusiones]=============================================*/
#include "chip.h"
#include "board.h"

/*==================[definiciones]================================================*/

/* Bumper Izquierdo
 * GPIO pin para interrupcin por PININT. GPIO7 EduCIAA */
#define BUMPER_IZQ				GPIO7
#define BUMPER_IZQ_PORT         3	/* Numero de puerto GPIO para mapear a PININT */ //GPIO3
#define BUMPER_IZQ_PIN          7	/* Numero de pin GPIO para mapear a PININT */	 //GPIO3[7]
#define BUMPER_IZQ_PIN_PORT     6	/* Numero de puerto SCU */	//P6
#define BUMPER_IZQ_PIN_BIT      11	/* Numero de pin SCU*/		//P6_11
#define BUMPER_IZQ_MODE_FUNC    SCU_MODE_FUNC0
#define BUMPER_IZQ_PININT_INDEX   3	/* Indice de PININT para mapeo de GPIO */
#define BUMPER_IZQ_PININT_IRQ_HANDLER  GPIO3_IRQHandler	/* Nombre de ISR PININT por GPIO */
#define BUMPER_IZQ_PININT_NVIC_NAME    PIN_INT3_IRQn	/* Nombre de fuente de interrupcin */

/* Bumper derecho.
 * GPIO pin para interrupcin por PININT. CAN_RD EduCIAA */
#define BUMPER_DER				T_FIL1
#define BUMPER_DER_PORT         2	/* Numero de puerto GPIO para mapear a PININT */ //GPIO2
#define BUMPER_DER_PIN          1	/* Numero de pin GPIO para mapear a PININT */	 //GPIO2[1]
#define BUMPER_DER_PIN_PORT     4	/* Numero de puerto SCU */	//P4
#define BUMPER_DER_PIN_BIT      1	/* Numero de pin SCU*/		//P4_1
#define BUMPER_DER_MODE_FUNC    SCU_MODE_FUNC0
#define BUMPER_DER_PININT_INDEX   4	/* Indice de PININT para mapeo de GPIO */
#define BUMPER_DER_PININT_IRQ_HANDLER  GPIO4_IRQHandler	/* Nombre de ISR PININT por GPIO */
#define BUMPER_DER_PININT_NVIC_NAME    PIN_INT4_IRQn	/* Nombre de fuente de interrupcin */


/* Prototipos de funciones */

// Manejador de Interrupciones para el Bumper Izquierdo
void BUMPER_IZQ_PININT_IRQ_HANDLER(void);

// Manejador de Interrupciones para el Bumper Derecho
void BUMPER_DER_PININT_IRQ_HANDLER(void);

int init_bumpers(void);

/*==================[end of file]============================================*/
#endif /* #ifndef _BUMPERS_H_ */

