#ifndef COMUNICACION_H_
#define COMUNICACION_H_

/*==================[inclusiones]=============================================*/
#include "sapi.h"
#include "sapi_peripheral_map.h"

/*  CLI: Inclusiones */
#include <string.h>
#include <stdlib.h>
/* /CLI: Inclusiones */


/*==================[definiciones]=================================*/


#define LPC_UARTX       LPC_USART2
#define UARTx_IRQn      USART2_IRQn
#define UARTx_IRQHandler UART2_IRQHandler

/*  CLI: Macros y Definiciones */
//this following macro is good for debugging, e.g.  print2("myVar= ", myVar);
#define print2(x,y) (print(x), print_int(y))


#define CR '\r'
#define LF '\n'
#define BS '\b'
#define NULLCHAR '\0'
#define SPACE ' '

#define COMMAND_BUFFER_LENGTH        25     	//length of serial buffer for incoming commands

/* /CLI: Macros y Definiciones */

/* Prototipos de funciones */

int init_usb_com(void);
int comunicate(void);
int println(char * cadena);
int print(const char * cadena);
int print_int(int valor);
int print_float8dig(float valor);


/*  CLI: Funciones */
/*****************************************************************************
  Simple and Clear Command Line Interpreter

     This file will allow you to type commands into the Serial Window like,
        add 23,599
        blink 5
        playSong Yesterday

     Implementation note:  This will use C strings as opposed to String Objects based on the assumption that if you need a commandLine interpreter,
     you are probably short on space too and the String object tends to be space inefficient.

   1)  Simple Protocol
         Commands are words and numbers either space or comma separated
         The first word is the command, each additional word is an argument
         "\n" terminates each command

   2)  Using the C library routine strtok:
       A command is a word separated by spaces or commas.  A word separated by certain characters (like space or comma) is called a token.
       To get tokens one by one, I use the C lib routing strtok (part of C stdlib.h see below how to include it).
           It's part of C language library <string.h> which you can look up online.  Basically you:
              1) pass it a string (and the delimeters you use, i.e. space and comman) and it will return the first token from the string
              2) on subsequent calls, pass it NULL (instead of the string ptr) and it will continue where it left off with the initial string.
        I've written a couple of basic helper routines:
            readNumber: uses strtok and atoi (atoi: ascii to int, again part of C stdlib.h) to return an integer.
              Note that atoi returns an int and if you are using 1 byte ints like uint8_t you'll have to get the lowByte().
            readWord: returns a ptr to a text word

   4)  DoMyCommand: A list of if-then-elses for each command.  You could make this a case statement if all commands were a single char.
      Using a word is more readable.
          For the purposes of this example we have:
              Add
              Subtract
              nullCommand
 */
/******************sample main loop code ************************************

  #include "CommandLine.h"

  void
  setup() {
  Serial.begin(115200);
  }

  void
  loop() {
  bool received = getCommandLineFromSerialPort(CommandLine);      //global CommandLine is defined in CommandLine.h
  if (received) DoMyCommand(CommandLine);
  }

 **********************************************************************************/
/*************************************************************************************************************
    getCommandLineFromSerialPort()
      Return the string of the next command. Commands are delimited by return"
      Handle BackSpace character
      Make all chars lowercase
*************************************************************************************************************/
bool getCommandLineFromSerialPort(char * commandLine);

/* ****************************
   readNumber: return a 16bit (for Arduino Uno) signed integer from the command line
   readWord: get a text word from the command line

*/
int readNumber (void);
char * readWord(void);
void nullCommand(char * ptrToCommandName);

/****************************************************
   Add your commands here
*/
int addCommand(void);
int subtractCommand(void);


/****************************************************
   DoMyCommand
*/
bool DoMyCommand(char * commandLine);

/* /CLI: Funciones */



/*==================[end of file]============================================*/
#endif /* COMUNICACION_H_ */
