#ifndef _IRLINEA_H_
#define _IRLINEA_H_

/*==================[inclusiones]=============================================*/
#include "sapi.h"              // Libreras sAPI, las vamos a usar en todos los proyectos


/*==================[definiciones]================================================*/

/*----------------------- Opciones configurables ------------------------------*/

#define LINEA_UMBRAL 		60				// Umbral promedio: se debe ajustar de acuerdo al comportamiento de los sensores
#define LINEA_HISTERESIS	20				// Histresis: Idem anterior
#define LINEA_BLANCO		TRUE			// Valor lgico para el material reflectivo (depende del diseo de hardware)
#define LINEA_NEGRO			FALSE			// Valor lgico para el material opaco (depende del diseo de hardware)
#define CANAL_LINEA_IZQ		CH2				// Canal de ADC donde se conecta el sensor izquierdo
#define	CANAL_LINEA_DER		CH1				// Canal de ADC donde se conecta el sensor derecho
#define LINEA_COLOR			LINEA_NEGRO		// Color de la lnea que se desea seguir

/*=============================================================================*/

#define LINEA_ID_IZQUIERDA	1
#define LINEA_ID_DERECHA	2

#define	LINEA_ADELANTE		3
#define	LINEA_GIRAR_IZQ		2
#define	LINEA_GIRAR_DER		1
#define	LINEA_DETENER		0

typedef struct
{
	uint16_t value;
	uint16_t threshold;
	uint16_t hysteresis;
	bool_t state;
	adcMap_t channel;
}ir_sensor_t;


/* Prototipos de funciones */

int init_linea(void);
bool_t leer_sensor_ir(uint8_t ir_sensor_id);
uint8_t	seguir_linea(void);
bool_t actualizar_ir_sensor(ir_sensor_t *ir_sensor);


/*==================[end of file]============================================*/
#endif /* #ifndef _IRLINEA_H_ */
