/*==================[inclusiones]=============================================*/
#include "motores.h"
#include "sapi.h"
#include "math.h"


/*==================[Funciones publicas]======================================*/

int init_motores(void)
{
	/* Configurar pines de EduCIAA GPIO2, GPIO5 y GPIO7 como salidas */
	/** H Bridge : 4 salidas digitales
	 * GPIO3: INH	--> P6_7	- FUNC4 - GPIO5[15]
	 * GPIO5: A		--> P6_9	- FUNC0 - GPIO3[5]
	 * GPIO7: B		--> P6_11	- FUNC0 - GPIO3[7]
	 **/
	gpioConfig(GPIO_MOTOR_INH, GPIO_ENABLE); 		//habilitacion
	gpioConfig(GPIO_MOTOR_INH, GPIO_OUTPUT);

	gpioConfig(GPIO_MOTOR_IZQ_DIR, GPIO_ENABLE); 	//direccion motor izquierdo
	gpioConfig(GPIO_MOTOR_IZQ_DIR, GPIO_OUTPUT);


	gpioConfig(GPIO_MOTOR_DER_DIR, GPIO_ENABLE); 		//direccin motor derecho
	gpioConfig(GPIO_MOTOR_DER_DIR, GPIO_OUTPUT);


	init_pwm();

	return 1;
}


void init_pwm(void) {

	/* Habilitacin general */
	pwmConfig( 0, PWM_ENABLE);

	/** Salidas PWM: 4 pines
	 * T_COL0: PWM_IZQ	--> P1_5 - FUNC1 - CTOUT_10 - PWM2 de sAPI
	 * T_FIL2: PWM_DER	--> P4_2 - FUNC1 - CTOUT_0  - PWM3 de sAPI
	 **/
	/* Configuracin de pines como salida PWM */
	pwmConfig(PWM_MOTOR_IZQ, PWM_ENABLE_OUTPUT);
	pwmConfig(PWM_MOTOR_DER, PWM_ENABLE_OUTPUT);

	/* Valores iniciales */


}

/*Valor como porcentaje de la vel_max. Va de -100 a 100 */

void	set_vel_lin(int8_t vel_lin){
	uint8_t velocidad_pwm;

	/*Chequeo de saturacin */
	if(vel_lin > 100){
		vel_lin = 100;
	} else if (vel_lin < -100){
		vel_lin = -100;
	}

	velocidad_pwm = (uint8_t) fabs( 2.55 * (float) vel_lin );

	if( vel_lin > 0 ){
		gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
		gpioWrite( GPIO_MOTOR_IZQ_DIR, MOTOR_AVANZA );
		gpioWrite( GPIO_MOTOR_DER_DIR, MOTOR_AVANZA );
		pwmWrite( PWM_MOTOR_IZQ, velocidad_pwm );
		pwmWrite( PWM_MOTOR_DER, velocidad_pwm );
	}
	else if( vel_lin < 0 ){
			gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
			gpioWrite( GPIO_MOTOR_IZQ_DIR, MOTOR_REVERSA );
			gpioWrite( GPIO_MOTOR_DER_DIR, MOTOR_REVERSA );
			pwmWrite( PWM_MOTOR_IZQ, velocidad_pwm );
			pwmWrite( PWM_MOTOR_DER, velocidad_pwm );
		}
	else if( vel_lin == 0 ){
		gpioWrite( GPIO_MOTOR_INH, MOTOR_DESHABILITA );
		pwmWrite( PWM_MOTOR_IZQ, 0 );
		pwmWrite( PWM_MOTOR_DER, 0 );
	}


}

/* Valor como porcentaje de la vel_max. Va de -100 a 100
 * Negativo es antihorario y positivo es horario*/

void	set_vel_giro(int8_t vel_giro){
	uint8_t velocidad_pwm;

	/*Chequeo de saturacin */
	if(vel_giro > 100){
		vel_giro = 100;
	} else if (vel_giro < -100){
		vel_giro = -100;
	}

	velocidad_pwm = (uint8_t) fabs( 2.55 * (float) vel_giro );

	if( vel_giro > 0 ){
		gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
		gpioWrite( GPIO_MOTOR_IZQ_DIR, MOTOR_AVANZA );
		gpioWrite( GPIO_MOTOR_DER_DIR, MOTOR_REVERSA );
		pwmWrite( PWM_MOTOR_IZQ, velocidad_pwm );
		pwmWrite( PWM_MOTOR_DER, velocidad_pwm );
	}
	else if( vel_giro < 0 ){
			gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
			gpioWrite( GPIO_MOTOR_IZQ_DIR, MOTOR_REVERSA );
			gpioWrite( GPIO_MOTOR_DER_DIR, MOTOR_AVANZA );
			pwmWrite( PWM_MOTOR_IZQ, velocidad_pwm );
			pwmWrite( PWM_MOTOR_DER, velocidad_pwm );
		}
	else if( vel_giro == 0 ){
		gpioWrite( GPIO_MOTOR_INH, MOTOR_DESHABILITA );
		pwmWrite( PWM_MOTOR_IZQ, 0 );
		pwmWrite( PWM_MOTOR_DER, 0 );
	}
}

void	set_vel_der(int8_t vel){
	uint8_t velocidad_pwm;

	/*Chequeo de saturacin */
	if(vel > 100){
		vel = 100;
	} else if (vel < -100){
		vel = -100;
	}

	velocidad_pwm = (uint8_t) fabs( 2.55 * (float) vel );

	if( vel > 0 ){
		gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
		gpioWrite( GPIO_MOTOR_DER_DIR, MOTOR_AVANZA );
		pwmWrite( PWM_MOTOR_DER, velocidad_pwm );
	}
	else if( vel < 0 ){
			gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
			gpioWrite( GPIO_MOTOR_DER_DIR, MOTOR_REVERSA );
			pwmWrite( PWM_MOTOR_DER, velocidad_pwm );
		}
	else if( vel == 0 ){
		gpioWrite( GPIO_MOTOR_INH, MOTOR_DESHABILITA );
		pwmWrite( PWM_MOTOR_DER, 0 );
	}
}


void	set_vel_izq(int8_t vel){
	uint8_t velocidad_pwm;

	/*Chequeo de saturacin */
	if(vel > 100){
		vel = 100;
	} else if (vel < -100){
		vel = -100;
	}

	velocidad_pwm = (uint8_t) fabs( 2.55 * (float) vel );

	if( vel > 0 ){
		gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
		gpioWrite( GPIO_MOTOR_IZQ_DIR, MOTOR_AVANZA );
		pwmWrite( PWM_MOTOR_IZQ, velocidad_pwm );
	}
	else if( vel < 0 ){
			gpioWrite( GPIO_MOTOR_INH, MOTOR_HABILITA );
			gpioWrite( GPIO_MOTOR_IZQ_DIR, MOTOR_REVERSA );
			pwmWrite( PWM_MOTOR_IZQ, velocidad_pwm );
		}
	else if( vel == 0 ){
		gpioWrite( GPIO_MOTOR_INH, MOTOR_DESHABILITA );
		pwmWrite( PWM_MOTOR_IZQ, 0 );
	}
}

