/* -------------------- Inclusiones de modulos externos --------------------*/

#include "sapi.h"       // <= sAPI header
#include "eduromaa.h"

/* FUNCION PRINCIPAL, PUNTO DE ENTRADA AL PROGRAMA LUEGO DE RESET. */
int main(void){

   /* ------------- INICIALIZACIONES ------------- */

	/* Variable de Retardo NO bloqueante */
	delay_t delay_ir;

	/* Variables de configuracin de velocidad */
	int8_t vel_alta = 60; //PDG era 80
	int8_t vel_baja = 20; //PDG era 40

   /* Inicializar la placa */
   init_eduromaa();

   delayConfig(&delay_ir,20); // PDG era 200

   /* ------------- REPETIR POR SIEMPRE ------------- */
   while(1) {
	   estoy_vivo();

	   if( delayRead( &delay_ir ) ){

		   switch(seguir_linea()){
		   case LINEA_ADELANTE:
			   gpioWrite(LED1,OFF);
			   gpioWrite(LED2,ON);
			   gpioWrite(LED3,OFF);
				/* Motores: ambos avanzan a la misma velocidad */
				set_vel_der(vel_alta);
				set_vel_izq(vel_alta);
			   break;
		   case LINEA_GIRAR_DER:
			   gpioWrite(LED1,OFF);
			   gpioWrite(LED2,OFF);
			   gpioWrite(LED3,ON);
				/* Motores: motor izquierdo avanza a mayor velocidad que el derecho */
				set_vel_der(vel_baja);
				set_vel_izq(vel_alta);
			   break;
		   case LINEA_GIRAR_IZQ:
			   gpioWrite(LED1,ON);
			   gpioWrite(LED2,OFF);
			   gpioWrite(LED3,OFF);
				/* Motores: motor derecho avanza a mayor velocidad que el izquierdo */
				set_vel_der(vel_alta);
				set_vel_izq(vel_baja);
			   break;
		   case LINEA_DETENER:
		   default:
			   gpioWrite(LED1,OFF);
			   gpioWrite(LED2,OFF);
			   gpioWrite(LED3,OFF);
				/* Motores: ambos motores se detienen */
				set_vel_der(0);
				set_vel_izq(0);
			   break;
		   }
	   }
   }
   /* NO DEBE LLEGAR NUNCA AQUI, debido a que a este programa no es llamado
      por ningun S.O. */
   return 0 ;
}

/*==================[end of file]============================================*/
