#ifndef _MOTORES_H_
#define _MOTORES_H_

/*==================[inclusiones]=============================================*/
#include "stdint.h"


/*==================[definiciones]================================================*/

// Seales para velocidad de los motores
#define PWM_MOTOR_IZQ PWM3      // T_FIL2
#define PWM_MOTOR_DER PWM2      // T_COL0

// Seal de habilitacin general de motores
#define GPIO_MOTOR_INH T_COL2

// Seales para la direccin
#define GPIO_MOTOR_IZQ_DIR T_FIL0
#define GPIO_MOTOR_DER_DIR T_FIL3

#define MOTOR_AVANZA 		1U
#define MOTOR_REVERSA 		0U
#define MOTOR_HABILITA 		0U
#define MOTOR_DESHABILITA 	1U

/* Prototipos de funciones */

int 	init_motores(void);
void 	init_pwm(void);
void	set_vel_lin(int8_t vel_lin);
void	set_vel_giro(int8_t vel_ang);
void	set_vel_der(int8_t vel);
void	set_vel_izq(int8_t vel);


/*==================[end of file]============================================*/
#endif /* #ifndef _MOTORES_H_ */
