#ifndef _ODOMETRIA_H_
#define _ODOMETRIA_H_

/*==================[inclusiones]=============================================*/
#include "stdint.h"


/*==================[definiciones]================================================*/

#define CAP_IZQ	2
#define CAP_DER	3


typedef struct{
		uint32_t 	cuenta;			// Cantidad de pulsos de encoder contados
		uint32_t	flanco_actual; 	// Valor del TIMER en el ltimo evento capturado
		uint32_t	flanco_previo;	// Valor del TIMER en evento de captura anterior
		uint32_t	tiempo_flancos;	// Cantidad de cuentas del TIMER entre 2 ltimos flancos
		float 		rueda_vel; 		//[m/s]
}encoder_t;


/* Prototipos de funciones */

void init_odometria(void);
void get_encoders(encoder_t *izq, encoder_t *der);


/*==================[end of file]============================================*/
#endif /* #ifndef _ODOMETRIA_H_ */

