/*==================[inclusiones]=============================================*/
#include "bumpers.h"
#include "comunicacion.h"

/*==================[definiciones]================================================*/

static int cuenta_bump_izq = 0;
static int cuenta_bump_der = 0;

/*==================[Funciones publicas]======================================*/

/** bumper izquierdo */
void BUMPER_IZQ_PININT_IRQ_HANDLER(void)
{
	Chip_PININT_ClearIntStatus(LPC_GPIO_PIN_INT, PININTCH(BUMPER_IZQ_PININT_INDEX));

	print_int(cuenta_bump_izq++);
	print(" II\t");
}


/** bumper derecho */

void BUMPER_DER_PININT_IRQ_HANDLER(void)
{
	Chip_PININT_ClearIntStatus(LPC_GPIO_PIN_INT, PININTCH(BUMPER_DER_PININT_INDEX));

	print_int(cuenta_bump_der++);
	print(" ID\t");
}


int init_bumpers(void)
{
	/* BUMPER IZQUIERDO */
	/* Configurar Pin como GPIO */
	Chip_SCU_PinMuxSet(BUMPER_IZQ_PIN_PORT, BUMPER_IZQ_PIN_BIT,
             (SCU_MODE_INBUFF_EN | SCU_MODE_PULLUP | BUMPER_IZQ_MODE_FUNC) );

	/* Configurar GPIO como entrada */
	Chip_GPIO_SetPinDIRInput(LPC_GPIO_PORT, BUMPER_IZQ_PORT, BUMPER_IZQ_PIN);

	/* Configurar el canal de interrupcin en bloque SysCon */
	Chip_SCU_GPIOIntPinSel(BUMPER_IZQ_PININT_INDEX, BUMPER_IZQ_PORT, BUMPER_IZQ_PIN);

	/* Configurar interrupcin para flanco descendente */
	Chip_PININT_ClearIntStatus(LPC_GPIO_PIN_INT, PININTCH(BUMPER_IZQ_PININT_INDEX));
	Chip_PININT_SetPinModeEdge(LPC_GPIO_PIN_INT, PININTCH(BUMPER_IZQ_PININT_INDEX));
	Chip_PININT_EnableIntLow(LPC_GPIO_PIN_INT, PININTCH(BUMPER_IZQ_PININT_INDEX));

	/* Habilitar interrupcion en NVIC */
	NVIC_ClearPendingIRQ(BUMPER_IZQ_PININT_NVIC_NAME);
	NVIC_EnableIRQ(BUMPER_IZQ_PININT_NVIC_NAME);


	/* BUMPER DERECHO */

	/* Configurar Pin como GPIO */
	Chip_SCU_PinMuxSet(BUMPER_DER_PIN_PORT, BUMPER_DER_PIN_BIT,
             (SCU_MODE_INBUFF_EN | SCU_MODE_PULLUP | BUMPER_DER_MODE_FUNC) );

	/* Configurar GPIO como entrada */
	Chip_GPIO_SetPinDIRInput(LPC_GPIO_PORT, BUMPER_DER_PORT, BUMPER_DER_PIN);

	/* Configurar el canal de interrupcin en bloque SysCon */
	Chip_SCU_GPIOIntPinSel(BUMPER_DER_PININT_INDEX, BUMPER_DER_PORT, BUMPER_DER_PIN);

	/* Configurar interrupcin para flanco descendente */
	Chip_PININT_ClearIntStatus(LPC_GPIO_PIN_INT, PININTCH(BUMPER_DER_PININT_INDEX));
	Chip_PININT_SetPinModeEdge(LPC_GPIO_PIN_INT, PININTCH(BUMPER_DER_PININT_INDEX));
	Chip_PININT_EnableIntLow(LPC_GPIO_PIN_INT, PININTCH(BUMPER_DER_PININT_INDEX));

	/* Habilitar interrupcion en NVIC */
	NVIC_ClearPendingIRQ(BUMPER_DER_PININT_NVIC_NAME);
	NVIC_EnableIRQ(BUMPER_DER_PININT_NVIC_NAME);

	return 1;
}
