/*==================[inclusiones]=============================================*/
#include "odometria.h"
#include "sapi.h"
#include "comunicacion.h"
#include "creg_18xx_43xx.h"

/*==================[definiciones]==============================*/

encoder_t enc_izq, enc_der;

uint32_t frec_timer;

/*==================[Funciones publicas]======================================*/

void init_odometria(void){


	/*Configurar pin de Entrada de Captura
	 * ETH_TXD1: ENC_IZQ --> P1_20 - FUNC4 - T0_CAP2
	 */
	Chip_SCU_PinMux(0x1,20, MD_PLN_FAST, SCU_MODE_FUNC4);
	LPC_GIMA->CAP0_IN[0][2]= 0x20;

	/*Configurar pin de Entrada de Captura
	 * MDIO: ENC_DER	--> P1_17 - FUNC4 - T0_CAP3
	 */
	Chip_SCU_PinMux(1,17, MD_PLN_FAST, SCU_MODE_FUNC4);

	/*Ver que Canal 3 de todos los capture se configura distinto!*/
	LPC_GIMA->CAP0_IN[0][3]= 0x10;

	/* Habilitar TIMER0 y Resetearlo */
	Chip_TIMER_Init(LPC_TIMER0);
	Chip_RGU_TriggerReset(RGU_TIMER0_RST);
	while (Chip_RGU_InReset(RGU_TIMER0_RST)) {}

	/* Obtener frecuencia del reloj del TIMER0 */
	frec_timer = Chip_Clock_GetRate(CLK_MX_TIMER0);

	Chip_TIMER_Reset(LPC_TIMER0);
	Chip_TIMER_TIMER_SetCountClockSrc(LPC_TIMER0, TIMER_CAPSRC_RISING_PCLK, CAP_IZQ);


	Chip_TIMER_ClearCapture(LPC_TIMER0, CAP_IZQ);
	Chip_TIMER_CaptureRisingEdgeEnable(LPC_TIMER0, CAP_IZQ);

	Chip_TIMER_ClearCapture(LPC_TIMER0, CAP_DER);
	Chip_TIMER_CaptureRisingEdgeEnable(LPC_TIMER0, CAP_DER);



	/*Habilitar Interrupciones por captura */
	Chip_TIMER_CaptureEnableInt(LPC_TIMER0, CAP_IZQ);
	Chip_TIMER_CaptureEnableInt(LPC_TIMER0, CAP_DER);
	/* Habilitar interrupciones del timer */
	NVIC_EnableIRQ(TIMER0_IRQn);
	NVIC_ClearPendingIRQ(TIMER0_IRQn);

	Chip_TIMER_Enable(LPC_TIMER0);

	print("Frecuencia TIMER0: ");
	print_int(frec_timer);
	println(" Hz");
}

void get_encoders(encoder_t *izq, encoder_t *der){
	*izq = enc_izq;
	*der = enc_der;
}

void TIMER0_IRQHandler(void)
{

	if (Chip_TIMER_CapturePending(LPC_TIMER0, CAP_IZQ )) {
		Chip_TIMER_ClearCapture(LPC_TIMER0, CAP_IZQ);

		if (enc_izq.flanco_previo == 0){
			enc_izq.flanco_previo = Chip_TIMER_ReadCapture(LPC_TIMER0, CAP_IZQ);
			enc_izq.cuenta = 0;

		} else {

			enc_izq.flanco_actual = Chip_TIMER_ReadCapture(LPC_TIMER0, CAP_IZQ);
			enc_izq.cuenta++;

			// Si la cuenta actual es menor a la anterior, hubo un desborde del TIMER
			if(enc_izq.flanco_actual < enc_izq.flanco_previo){
				// El periodo es igual a lo que faltaba para quedesborde
				// (se obtiene haciendo el complemento a 2) mas el flanco actual
				enc_izq.tiempo_flancos = enc_izq.flanco_actual + (~enc_izq.flanco_previo) + 1;
			} else {
				enc_izq.tiempo_flancos = enc_izq.flanco_actual - enc_izq.flanco_previo;
			}
			if(enc_izq.tiempo_flancos < 1000) {
				enc_izq.rueda_vel = 0;
			} else {
				enc_izq.rueda_vel = (3 * frec_timer) / enc_izq.tiempo_flancos;
			}
			enc_izq.flanco_previo = enc_izq.flanco_actual;
		}

	}

	if (Chip_TIMER_CapturePending(LPC_TIMER0, CAP_DER )) {
		Chip_TIMER_ClearCapture(LPC_TIMER0, CAP_DER);
		if (enc_der.flanco_previo == 0){
			enc_der.flanco_previo = Chip_TIMER_ReadCapture(LPC_TIMER0, CAP_DER);
			enc_der.cuenta = 0;
		} else {
			enc_der.flanco_actual = Chip_TIMER_ReadCapture(LPC_TIMER0, CAP_DER);
			enc_der.cuenta++;

			// Si la cuenta actual es menor a la anterior, hubo un desborde del TIMER
			if(enc_der.flanco_actual < enc_der.flanco_previo){
				// El periodo es igual a lo que faltaba para que desborde
				// (se obtiene haciendo el complemento a 2) mas el flanco actual
				enc_der.tiempo_flancos = enc_der.flanco_actual + (~enc_der.flanco_previo) + 1;
			} else {
				enc_der.tiempo_flancos = enc_der.flanco_actual - enc_der.flanco_previo;
			}
			if(enc_der.tiempo_flancos < 1000) {
				enc_der.rueda_vel = 0;
			} else {
				enc_der.rueda_vel = (3 * frec_timer) / enc_der.tiempo_flancos;
			}
			enc_der.flanco_previo = enc_der.flanco_actual;
		}
	}
}
