# -*- coding: utf-8 -*-
""" Comparison with paper "Wishart Deep Stacking Network for Fast POLSAR Image Classification"

Usage:
  parameter_evaluation.py --dataset=<str>

Options:
  --dataset=<str>    path to the dataset
  -h --help          show this screen.
"""

import sys
from os import path
from docopt import docopt
import pandas


sys.path.append('.')
import sartb


if __name__ == "__main__":
    args = docopt(__doc__)
    ipath = path.abspath(str(args["--dataset"]))

    #ntimes = 1
    ntimes = 10
    dof = 5
    ncomp = 16

    dn = sartb.DatasetNames()

    columns = ['method', 'flev mean', 'flev var']

    overlap = False

    results = []
    result = ['Ours']
    for dataset in [dn.Flevoland]:
        mean, std = sartb.run_ntimes(ipath, dataset, 'fisher_vector', 'kmeans', 'real', ncomp, dof, ntimes,
                                     overlap, nblocks=645, block_size=1)
        result += [mean, std]
    results.append(result)

    df = pandas.DataFrame(results, columns=columns)
    print(df.to_string(index=False))
