# -*- coding: utf-8 -*-
""" Generation of the Parameter Evaluation Table of the Paper

Usage:
  parameter_evaluation.py --dataset=<str>

Options:
  --dataset=<str>    path to the dataset
  -h --help          show this screen.
"""

import sys
from os import path
from docopt import docopt
import pandas


sys.path.append('.')
import sartb


if __name__ == "__main__":
    args = docopt(__doc__)
    ipath = path.abspath(str(args["--dataset"]))

    ntimes = 10

    dofs = [4, 5, 6, 7]

    ncomps = [4, 8, 16, 32]

    overlap = False

    dataset_names = sartb.DatasetNames()
    dn = dataset_names.SanFrancisco

    unary_method = 'fisher_vector'

    wishart_init = 'kmeans'

    polsar_mode = 'real'

    columns = ['dof', 'ncomp', '{} mean'.format(dn), '{} var'.format(dn)]

    results = []
    for dof in dofs:
        for ncomp in ncomps:
            result = [dof, ncomp]
            mean, std = sartb.run_ntimes(ipath, dn, unary_method, wishart_init, polsar_mode, ncomp, dof,
                                         ntimes, overlap, nblocks=4, block_size=5)
            result += [mean, std]
            results.append(result)

    df = pandas.DataFrame(results, columns=columns)
    print(df.to_string(index=False))
