Fisher Vectors for PolSAR Image Classification
================================

Code used in paper:

   Javier Redolfi, Jorge Sánchez and Ana Georgina Flesia.
   "Fisher Vectors for PolSAR Image Classification".
   IEEE Geoscience and Remote Sensing Letters.

0. Features
---

The library consist basically of the following python modules:

 * PolSAR image manipulation: pseudocolor image generation, force SPD.
 * PolSAR datasets: San Francisco Bay, Flevoland and Foulum. Train/test splits generation, manual selection of
 training points. Accuracy and Confusion Matrix computation.
 * Smoothing algorithms: Potts, Graph Cut and Maximun.
 * Unary potential generation from Complex Wishart, Real Wishart Mixture and FV (RWM based).

1. Dependencies
---

 * vrl -> http://www.famaf.unc.edu.ar/~jsanchez/efv/
 * matplotlib
 * numpy
 * pygco -> http://vision.csd.uwo.ca/code/gco-v3.0.zip
 * pystruct -> https://pystruct.github.io/
 * scikit-image -> http://scikit-image.org/
 * scikit-learn -> scikit-learn.org/
 * scipy

2. Installation on Debian/Ubuntu
---

(use sudo for Ubuntu)

> \# apt-get install python2.7 python-matplotlib python-numpy python-skimage python-sklearn python-scipy

 * Install vrl using the README provided by the library.

> \# pip install pystruct

 * Install pygco using the gco_python/README.md provided by the library.

**2.2. Installing the module**

 * Just uncompress it.

3. Example: Comparison with paper "Pol-SAR Classification Based on Generalized Polar Decomposition of Mueller Matrix"
---

 * Download the dataset and uncompress it: -> https://www.dropbox.com/s/xulk8t5pizoceh5/dataset.tar.gz?dl=0
 * Run the script "python src/bin/comparison_mueller.py --dataset=path_to_dataset"
