# -*- coding: utf-8 -*-
""" Generation of the Parameter Evaluation Plot of the Paper

Usage:
  parameter_evaluation_plot.py

Options:
  -h --help          show this screen.
"""

import numpy as np
from matplotlib import pyplot as plt

#ncomps = [2, 4, 8, 16, 32]
ncomps = [4, 8, 16, 32]

#dof_4_mean = [0.902019, 0.961852, 0.968390, 0.960910, 0.951708]
#dof_4_std =  [0.076155, 0.009466, 0.007165, 0.025314, 0.022127]
#dof_5_mean = [0.898225, 0.959992, 0.968427, 0.970691, 0.964471]
#dof_5_std =  [0.075312, 0.009010, 0.007373, 0.007896, 0.017643]
#dof_6_mean = [0.894048, 0.958700, 0.965650, 0.968947, 0.959402]
#dof_6_std =  [0.075266, 0.009562, 0.007659, 0.010300, 0.020514]
#dof_7_mean = [0.888785, 0.955370, 0.962089, 0.967835, 0.965349]
#dof_7_std =  [0.075338, 0.011369, 0.009436, 0.009773, 0.016098]

dof_4_mean = [0.961852, 0.968390, 0.960910, 0.951708]
dof_4_std =  [0.009466, 0.007165, 0.025314, 0.022127]
dof_5_mean = [0.959992, 0.968427, 0.970691, 0.964471]
dof_5_std =  [0.009010, 0.007373, 0.007896, 0.017643]
dof_6_mean = [0.958700, 0.965650, 0.968947, 0.959402]
dof_6_std =  [0.009562, 0.007659, 0.010300, 0.020514]
dof_7_mean = [0.955370, 0.962089, 0.967835, 0.965349]
dof_7_std =  [0.011369, 0.009436, 0.009773, 0.016098]

plt.xlabel('Number of mixture components, K')
plt.ylabel('Accuracy (% x 100)')
plt.xlim([0.5, len(ncomps) + 0.5])
plt.xticks(np.arange(len(ncomps)) + 1, [str(i) for i in ncomps])
markersize = '5'
elinewidth = 1.
plt.errorbar(np.arange(len(ncomps)) + 1, dof_4_mean, yerr=dof_4_std, fmt='s-', label='n = 4', linewidth=2.0,
             elinewidth=elinewidth, markersize=markersize, ls='-')
plt.errorbar(np.arange(len(ncomps)) + 1, dof_5_mean, yerr=dof_5_std, fmt='s-', label='n = 5', linewidth=2.0,
             elinewidth=elinewidth, markersize=markersize, ls='--')
plt.errorbar(np.arange(len(ncomps)) + 1, dof_6_mean, yerr=dof_6_std, fmt='s-', label='n = 6', linewidth=2.0,
             elinewidth=elinewidth, markersize=markersize, ls='-.')
plt.errorbar(np.arange(len(ncomps)) + 1, dof_7_mean, yerr=dof_7_std, fmt='s-', label='n = 7', linewidth=2.0,
             elinewidth=elinewidth, markersize=markersize, ls=':')
plt.legend(loc='lower left')
plt.grid(True)
output_file = 'parameter_evaluation.eps'
print('Generating {}'.format(output_file))
plt.savefig(output_file, bbox_inches='tight')
#plt.show()
plt.clf()
