# -*- coding: utf-8 -*-
""" Generation of the Comparison with other methods Table of the Paper

Usage:
  parameter_evaluation.py --dataset=<str>

Options:
  --dataset=<str>    path to the dataset
  -h --help          show this screen.
"""

import sys
from os import path
from docopt import docopt
import pickle


sys.path.append('.')
import sartb


if __name__ == "__main__":
    args = docopt(__doc__)
    ipath = path.abspath(str(args["--dataset"]))

    ntimes = 10
    dof_fv = 5
    ncomps_cw = [1]
    ncomps_rwm = [1, 2, 4, 8, 16, 32]
    ncomps_fv = [1, 2, 4, 8, 16, 32]
    #ncomps_rwm = [2, 16]
    #ncomps_fv = [2, 16]

    results = {}
    results['ncomps_cw'] = ncomps_cw
    results['ncomps_rwm'] = ncomps_rwm
    results['ncomps_fv'] = ncomps_fv

    dn = sartb.DatasetNames()

    block_size = 5
    #block_size = 6

    dataset = dn.SanFrancisco
    #dataset = dn.Flevoland

    wishart_init = 'kmeans'

    overlap = False

    # Complex Wishart Classifier
    mean, std = sartb.run_ntimes(ipath, dataset, 'wishart_classifier', wishart_init, polsar_mode='com', ncomp=1,
                                 dof=3, ntimes=ntimes, overlap=overlap, nblocks=4, block_size=block_size)

    mean_cw = [mean]
    std_cw = [std]
    results['mean_cw'] = mean_cw
    results['std_cw'] = std_cw

    # Real Wishart Mixture
    mean_rwm = []
    std_rwm = []
    for ncomp in ncomps_rwm:
        mean, std = sartb.run_ntimes(ipath, dataset, 'wishart_mixture', wishart_init, 'real', ncomp, 3,
                                     ntimes, overlap, nblocks=4, block_size=block_size)
        mean_rwm += [mean]
        std_rwm += [std]

    results['mean_rwm'] = mean_rwm
    results['std_rwm'] = std_rwm

    # Fisher Vector
    mean_fv = []
    std_fv = []
    for ncomp in ncomps_fv:
        mean, std = sartb.run_ntimes(ipath, dataset, 'fisher_vector', wishart_init, 'real', ncomp, dof_fv,
                                     ntimes, overlap, nblocks=4, block_size=block_size)
        mean_fv += [mean]
        std_fv += [std]

    results['mean_fv'] = mean_fv
    results['std_fv'] = std_fv

    pickle.dump(results, open('{}_bs_{}_percentil_95.results'.format(dataset, block_size), 'w'))
