# -*- coding: utf-8 -*-
""" Generation of the Comparison Plots with other methods

Usage:
  rwm_vs_fv_plot.py
"""

import pickle
from matplotlib import pyplot as plt
import numpy as np

def plot_results(dataset_name):
    results_file ='{}.results'.format(dataset_name)
    print('Reading {}.'.format(results_file))
    results = pickle.load(open(results_file, 'r'))

    ncomps_cw = results['ncomps_cw']
    ncomps_rwm = results['ncomps_rwm']
    ncomps_fv = results['ncomps_fv']

    mean_cw = results['mean_cw']
    std_cw = results['std_cw']

    mean_rwm = results['mean_rwm']
    std_rwm = results['std_rwm']

    mean_fv = results['mean_fv']
    std_fv = results['std_fv']

    ax = plt.subplot(1, 1, 1)

    ax.set_xlabel('Number of mixture components, K')
    ax.set_ylabel('Accuracy (% x 100)')
    ax.set_xlim([0.5, len(ncomps_fv) + 0.5])
    #ax.set_xticks(np.arange(len(ncomps_fv)) + 1, [str(i) for i in ncomps_fv])
    ax.set_xticks(np.arange(len(ncomps_fv)) + 1)
    ax.set_xticklabels([str(i) for i in ncomps_fv])
    ax.errorbar(np.arange(len(ncomps_fv)) + 1, mean_fv, yerr=std_fv, fmt='s-', label='Ours', linewidth=2.0,
                elinewidth=1.5, markersize='10')
    ax.errorbar(np.arange(len(ncomps_rwm)) + 1, mean_rwm, yerr=std_rwm, fmt='o--', label='RWM', linewidth=2.0,
                elinewidth=1.5, markersize='10')
    ax.errorbar(np.arange(len(ncomps_cw)) + 1, mean_cw, yerr=std_cw, fmt='^-', label='CWC', linewidth=2.0,
                elinewidth=1.5, markersize='10')
    handles, labels = ax.get_legend_handles_labels()
    ax.legend(handles[::-1], labels[::-1], loc='lower right')
    #plt.legend(loc='lower right')
    ax.grid(True)
    output_file = 'rwm_vs_fv_{}.eps'.format(dataset_name)
    print('Generating {}'.format(output_file))
    plt.savefig(output_file, bbox_inches='tight')
    #plt.show()
    plt.clf()
    print('')

plot_results('SanFrancisco_bs_5_percentil_95')
plot_results('Flevoland_bs_5_percentil_95')
