# -*- coding: utf-8 -*-
from __future__ import absolute_import

import logging


import vrl


from .potts import potts
from .graph_cut import graph_cut
from .maximum import maximum


logger = vrl.utils.get_logger('sartb')
vrl.utils.set_loglevel(logging.INFO)


def smoothing(unary, smoothing_algo='graph_cut'):
    assert(smoothing_algo in ['potts', 'graph_cut', 'maximum'])

    if(smoothing_algo is 'potts'):
        logging.info("Fitting potts model")
        #inference_method = 'qpb'
        inference_method = 'ad3'
        y = potts(unary, inference_method=inference_method)

    if(smoothing_algo is 'graph_cut'):
        logging.info("Graph cut")
        y = graph_cut(unary)

    if(smoothing_algo is 'maximum'):
        logging.info("Maximum")
        y = maximum(unary)

    return y
