addpath('../software/libsvm-3.12/matlab/');

arg_list = argv();

img = imread(arg_list{1,1});

try
  if(size(img)(3)==3)
    img = rgb2gray(img);
  endif
end_try_catch

img = double(img);
img = img/max(max(img));

px = size(img)(1);
py = size(img)(2);

[u, testVectors] = genEdgeTrainVectors(img, img); % u is a dummy var, we don't know the true edges

load(arg_list{2,1});

yp = svmpredict(u, testVectors, model);

for x = 2:1:px-1
  for y = 2:1:py-1
    img(x,y) = yp((x-2)*(px-2)+(y-1));
  end
end

save(arg_list{3,1}, 'img');
