clear all;

p = 32;
meanDiff = 10;
maxValue = 20;
meanDark = (maxValue-meanDiff)/2;
meanBright = meanDark + meanDiff;

% diagonal edge 1
diagEdge1 = tril(ones(p))*meanDark + triu(ones(p),1)*meanBright + randn(p,p);
diagEdge1 = diagEdge1/maxValue;

imwrite(diagEdge1, 'img/diagEdge1.png');

%labelDiagEdge1 = ones(p,p) - 2*eye(p,p) - 2*diag(ones(p-1,1),1);
labelDiagEdge1 = ones(p,p) - 2*eye(p,p);

[a,b] = genEdgeTrainVectors(diagEdge1, labelDiagEdge1);

edgeTrainLbl = [];
edgeTrainLbl = [edgeTrainLbl;a];

edgeTrainVectors = [];
edgeTrainVectors = [edgeTrainVectors;b];

% diagonal edge 2
diagEdge2 = 1 - diagEdge1;
labelDiagEdge2 = labelDiagEdge1;

imwrite(diagEdge2, 'img/diagEdge2.png');

[a,b] = genEdgeTrainVectors(diagEdge2, labelDiagEdge2);

edgeTrainLbl = [edgeTrainLbl;a];

edgeTrainVectors = [edgeTrainVectors;b];

% horizontal edge
horEdge = zeros(p,p);
horEdge(1:p/2,:) = ones(p/2,p)*meanDark;
horEdge(p/2+1:p,:) = ones(p/2,p)*meanBright;
horEdge = horEdge + randn(p,p);

horEdge = horEdge/maxValue;

labelHorEdge = ones(p,p);
%labelHorEdge(p/2:p/2+1,:) = -1;
labelHorEdge(p/2,:) = -1;

imwrite(horEdge, 'img/horEdge.png');

[a,b] = genEdgeTrainVectors(horEdge, labelHorEdge);

edgeTrainLbl = [edgeTrainLbl;a];

edgeTrainVectors = [edgeTrainVectors;b];

% vertical edge
verEdge = zeros(p,p);
verEdge(:,1:p/2) = ones(p,p/2)*meanDark;
verEdge(:,p/2+1:p) = ones(p,p/2)*meanBright;
verEdge = verEdge + randn(p,p);

verEdge = verEdge/maxValue;

labelVerEdge = ones(p,p);
%labelVerEdge(:,p/2:p/2+1) = -1;
labelVerEdge(:,p/2) = -1;

imwrite(verEdge, 'img/verEdge.png');

[a,b] = genEdgeTrainVectors(verEdge, labelVerEdge);

edgeTrainLbl = [edgeTrainLbl;a];

edgeTrainVectors = [edgeTrainVectors;b];

save 'data/edgeTrainVectors.txt' edgeTrainVectors
save 'data/edgeTrainLbl.txt' edgeTrainLbl

