function cleanEdge = filterEdge( img, thr )
  px = size(img)(1);
  py = size(img)(1);

  cleanEdge = zeros(px,py);

  edge = img>thr;

  for i = 1:px
    colImg = img(i,:);
    colEdge = edge(i,:);
    indexs = getClustersIndex( colEdge );
    for j = 1:2:length(indexs)
      [val, ind] = max(colImg(1,indexs(j):indexs(j+1)));
      cleanEdge(i,ind+indexs(j)) = 1;
    end
    cleanEdge(i,:);
  end
  for i = 1:py
    rowImg = img(:,i);
    rowEdge = edge(:,i);
    indexs = getClustersIndex( rowEdge );
    for j = 1:2:length(indexs)
      [val, ind] = max(rowImg(indexs(j):indexs(j+1),1));
      cleanEdge(ind+indexs(j),i) = 1;
    end
  end
endfunction
