function [lbl, vect] = genEdgeTrainVectors( featMat, lblMat )
  px = size(featMat)(1);
  py = size(featMat)(2);
  lbl = zeros((px-2)*(py-2),1);
  vect = zeros((px-2)*(py-2),8);
  for x = 2:1:px-1
    for y = 2:1:py-1
      value = featMat(x,y);
      lbl((x-2)*(px-2)+(y-1)) = lblMat(x,y);
      vect((x-2)*(px-2)+(y-1),1) = featMat(x-1,y-1)-value;
      vect((x-2)*(px-2)+(y-1),2) = featMat(x-1,y)-value;
      vect((x-2)*(px-2)+(y-1),3) = featMat(x-1,y+1)-value;
      vect((x-2)*(px-2)+(y-1),4) = featMat(x,y-1)-value;
      vect((x-2)*(px-2)+(y-1),5) = featMat(x,y+1)-value;
      vect((x-2)*(px-2)+(y-1),6) = featMat(x+1,y-1)-value;
      vect((x-2)*(px-2)+(y-1),7) = featMat(x+1,y)-value;
      vect((x-2)*(px-2)+(y-1),8) = featMat(x+1,y+1)-value;
    end
  end
endfunction
