randn('state',42); % fixed state for random numbers
N = 100; % number of samples
u = linspace(0,1,N)'; % input data
y = 1 ./ (0.1 + u) + 0.3*randn(N,1); % process to be modeled


% --- define svm options ---

svm_type = 3; % epsilon SVM
kernel_type = 2; % RBF kernel: exp(-gamma*|u-v|^2)
gamma = 10; % 'width' of the Gaussian basis function
cost = 100; % C parameter in loss function
epsilon = 0.1; % epsilon parameter in loss function

options = ['-s ', num2str(svm_type),...
' -t ', num2str(kernel_type),...
' -g ', num2str(gamma),...
' -c ', num2str(cost),...
' -p ', num2str(epsilon)];

% --- solve the problem ---

fprintf('Starting LIBSVM\n');
tic;
model = svmtrain(y, u, options);
fprintf('Optimization finished in %3.2f sec\n',toc);


% --- plot the solution ---

yp = svmpredict(y, u, model);

figure
plot(u,y,'*')
hold
plot(u,yp,'r','linewidth',2)
xlabel('u')
ylabel('y')
legend('process','model')
