clear all;

px = 200;
py = 200;
mux = px/2;
muy = py/2;
var = (px+py)/8;

noise = 0.1;

normPdfX = normpdf(0:1:px-1, mux, var);
normPdfY = normpdf(0:1:py-1, muy, var);

img = normPdfX'*normPdfY;
img = img/min(min(img));
img = img/max(max(img));

img = 1 - img;

imwrite(img, "img/gaussian.png")

trueValues = zeros((px-2)*(py-2),1);
for x = 2:1:px-1
  for y = 2:1:py-1
    trueValues((x-2)*(px-2)+(y-1)) = img(x,y);
  end
end

nImg = 1 - img;

noiseMatrix = rand(px,py)>noise;
nImg = nImg.*noiseMatrix;

nImg = 1 - nImg;

trainVectors = zeros((px-2)*(py-2),9);
for x = 2:1:px-1
  for y = 2:1:py-1
    trainVectors((x-2)*(px-2)+(y-1),1) = nImg(x-1,y-1);
    trainVectors((x-2)*(px-2)+(y-1),2) = nImg(x-1,y);
    trainVectors((x-2)*(px-2)+(y-1),3) = nImg(x-1,y+1);
    trainVectors((x-2)*(px-2)+(y-1),4) = nImg(x,y-1);
    trainVectors((x-2)*(px-2)+(y-1),5) = nImg(x,y);
    trainVectors((x-2)*(px-2)+(y-1),6) = nImg(x,y+1);
    trainVectors((x-2)*(px-2)+(y-1),7) = nImg(x+1,y-1);
    trainVectors((x-2)*(px-2)+(y-1),8) = nImg(x+1,y);
    trainVectors((x-2)*(px-2)+(y-1),9) = nImg(x+1,y+1);
  end
end

imwrite(nImg, "img/gaussianNoise.png")

save 'data/regTrainLabels.txt' trainVectors
save 'data/regTrainFeatures.txt' trueValues



