addpath('../software/libsvm-3.12/matlab/');

arg_list = argv();

houseImg = imread(arg_list{1,1});
houseImg = double(houseImg);
houseImg = houseImg/max(max(houseImg));

px = size(houseImg)(1);
py = size(houseImg)(2);

testVectors = zeros((px-2)*(py-2),9);
for x = 2:1:px-1
  for y = 2:1:py-1
    testVectors((x-2)*(px-2)+(y-1),1) = houseImg(x-1,y-1);
    testVectors((x-2)*(px-2)+(y-1),2) = houseImg(x-1,y);
    testVectors((x-2)*(px-2)+(y-1),3) = houseImg(x-1,y+1);
    testVectors((x-2)*(px-2)+(y-1),4) = houseImg(x,y-1);
    testVectors((x-2)*(px-2)+(y-1),5) = houseImg(x,y);
    testVectors((x-2)*(px-2)+(y-1),6) = houseImg(x,y+1);
    testVectors((x-2)*(px-2)+(y-1),7) = houseImg(x+1,y-1);
    testVectors((x-2)*(px-2)+(y-1),8) = houseImg(x+1,y);
    testVectors((x-2)*(px-2)+(y-1),9) = houseImg(x+1,y+1);
  end
end

u = testVectors(:,5);

load(arg_list{2,1});

yp = svmpredict(u, testVectors, model);

for x = 2:1:px-1
  for y = 2:1:py-1
    houseImg(x,y) = yp((x-2)*(px-2)+(y-1));
  end
end

imwrite(houseImg, arg_list{3,1});

