addpath('../software/libsvm-3.12/matlab/');

arg_list = argv();

svm_type = 3; % epsilon SVM
kernel_type = 2; % RBF kernel: exp(-gamma*|u-v|^2)
gamma = str2num(arg_list{3,1}); % 'width' of the Gaussian basis function
cost = str2num(arg_list{4,1}); % C parameter in loss function
epsilon = 0.1; % epsilon parameter in loss function

options = ['-s ', num2str(svm_type),' -t ', num2str(kernel_type),' -g ', num2str(gamma),' -c ', num2str(cost),' -p ', num2str(epsilon)];

load(arg_list{1,1}); % labels
load(arg_list{2,1}); % features

fprintf('Starting LIBSVM\n');
tic;
model = svmtrain(trueValues, trainVectors, options);
fprintf('Optimization finished in %3.2f sec\n',toc);

save(arg_list{5,1},'model')

