#include "lpc2114.h"

// Values of Bits 0-3 in PINSEL to activate UART0
#define UART0_PINSEL    ((PINSEL_FIRST_ALT_FUNC<<PINSEL_BITPIN0)|(PINSEL_FIRST_ALT_FUNC<<PINSEL_BITPIN1))

#define UART_BAUD(baud) (unsigned int)(((FOSC*PLL_M/VPBDIV_VAL) / ((baud) * 16.0)) + 0.5)

//#define UART_BAUD(baud) (unsigned int)(((FOSC*PLL_M/VPBDIV_VAL) / ((baud) * 16.0)) + 0.5)

// Mask of Bits 0-4
/* on LPC210x: UART0 TX-Pin=P0.2, RX-Pin=P0.1 
   PINSEL0 has to be set to "UART-Function" = Function "01" 
   for Pin 0.0 and 0.1 */

#define UIER_ERBIE          (1 << 0)    // Enable Receive Data Available Interrupt
#define PINSEL_BITPIN0  0
#define PINSEL_BITPIN1  2
// #define PINSEL_BITPIN2  4
#define PINSEL_FIRST_ALT_FUNC   1
#define UART0_PINMASK      (0x0000000F)    // PINSEL0 Mask for UART0
#define FOSC		14745600
#define PLL_M		4	
#define MSEL		(PLL_M-1)
#define PSEL0 		5
#define PSEL1 		6

#define PLLE		0
#define PLLC		1

#define PLOCK		10

#define PLL_FEED1	0xAA
#define PLL_FEED2	0x55

#define VPBDIV_VAL	1
#define TX_BUF_LEN	160
#define RX_BUF_LEN	160
#define RX_PACKET_BUF_LEN 5
#define	TX_PACKET_BUF_LEN 5
#define VPBDIV_VAL	1

#define	SOURCE_THRE        			0x2
#define SOURCE_RX_TIMEOUT 			0xc
#define SOURCE_ERROR      			0x6
#define SOURCE_RX         			0x4
#define INTERRUPT_SOURCE_MASK		0xF

#define INIT_FRAME	'*'
#define END_FRAME 0xd       //retorno de carro

#define FALSE 0
#define TRUE 1

// Values of Bits 0-3 in PINSEL to activate UART0
#define UART0_PINSEL    ((PINSEL_FIRST_ALT_FUNC<<PINSEL_BITPIN0)|(PINSEL_FIRST_ALT_FUNC<<PINSEL_BITPIN1))
// Mask of Bits 0-4
#define UART0_PINMASK      (0x0000000F)    // PINSEL0 Mask for UART0

// U0_LCR devisor latch bit 
#define UART0_LCR_DLAB  7

enum{IDLE,TRANSMITTING, RECEIVING, BOTH};
enum{NO_ERROR,RX_PACKET_BUF_OVERFLOW, TX_PACKET_BUF_OVERFLOW, RX_AND_TX_PACKET_BUF_OVERFLOW};  //PONER EN INCLUDE

#define BUF_FULL -2
#define ERROR -1

int send_packet(char* buf, int count);
int receive_packet(char* buf);
void com_init(void);
void irq_communication(void);
void simulacion_communication(unsigned int fuente,unsigned char *buf_rx_uart, unsigned int tam_buf);
